﻿//////////////////////////////////////////////////////////////////////////////
// GetDestinationsNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class GetDestinationsNotificationTest
    {
        [TestMethod]
        public void GetDestinationsNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""getDestinations"",
                                        ""guid"" : 12345,
                                        ""allowTransferToSkillset"" : true,
                                        ""allowTransferToAgent"" : true,
                                        ""queues"" : [
                                            {
                                                ""queueName"" : ""wc_sales"",
                                                ""queueId"" : 13,
                                                ""queueCCMSId"" : 9998,
                                                ""routepoint"" : ""WebChatRP"",
                                                ""agents"" : [
                                                    {
                                                        ""agentId"" : ""111"",
                                                        ""displayName"" : ""John""
                                                    },
                                                    {
                                                        ""agentId"" : ""222"",
                                                        ""displayName"" : ""Mike""
                                                    }
                                                ]
                                            },
                                            {
                                                ""queueName"" : ""wc_support"",
                                                ""queueId"" : 14,
                                                ""queueCCMSId"" : 9999,
                                                ""routepoint"" : ""WebChatRP"",
                                                ""agents"" : [
                                                    {
                                                        ""agentId"" : ""333"",
                                                        ""displayName"" : ""Bob""
                                                    },
                                                    {
                                                        ""agentId"" : ""444"",
                                                        ""displayName"" : ""Kevin""
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                }";

            JDecoder jdecode = new JDecoder();
            GetDestinationsNotification note = (GetDestinationsNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "getDestinations");
            Assert.AreEqual(note.body.guid, 12345);
            Assert.AreEqual(note.body.allowTransferToSkillset, true);
            Assert.AreEqual(note.body.allowTransferToAgent, true);

            Assert.AreEqual(note.body.queues[0].queueName, "wc_sales");
            Assert.AreEqual(note.body.queues[0].queueId, 13);
            Assert.AreEqual(note.body.queues[0].queueCCMSId, 9998);
            Assert.AreEqual(note.body.queues[0].routepoint, "WebChatRP");
            Assert.AreEqual(note.body.queues[0].agents[0].agentId, "111");
            Assert.AreEqual(note.body.queues[0].agents[0].displayName, "John");
            Assert.AreEqual(note.body.queues[0].agents[1].agentId, "222");
            Assert.AreEqual(note.body.queues[0].agents[1].displayName, "Mike");

            Assert.AreEqual(note.body.queues[1].queueName, "wc_support");
            Assert.AreEqual(note.body.queues[1].queueId, 14);
            Assert.AreEqual(note.body.queues[1].queueCCMSId, 9999);
            Assert.AreEqual(note.body.queues[1].routepoint, "WebChatRP");
            Assert.AreEqual(note.body.queues[1].agents[0].agentId, "333");
            Assert.AreEqual(note.body.queues[1].agents[0].displayName, "Bob");
            Assert.AreEqual(note.body.queues[1].agents[1].agentId, "444");
            Assert.AreEqual(note.body.queues[1].agents[1].displayName, "Kevin");
        }
    }
}