﻿//////////////////////////////////////////////////////////////////////////////
// NewPagePushRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class NewPagePushRequestTest
    {
        [TestMethod]
        public void NewPagePushRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""pagePush"",""guid"":123456,""url"":""www.avaya.com"",""destination"":""newBrowserTab""}}";

            NewPagePushRequest temp = new NewPagePushRequest();
            temp.apiVersion = NewPagePushRequest.JSapiVersion.one_point_zero;

            temp.body.guid = 123456;
            temp.body.url = "www.avaya.com";
            temp.body.destination = NewPagePushRequest.JSpagePushDestination.newBrowserTab;

            JEncoder e = new JEncoder();
            String response = e.Encode(temp);

            Assert.AreEqual(response, jsonExpected);

        }
    }
}
