﻿//////////////////////////////////////////////////////////////////////////////
// ProcessResourcesTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using CustomDesktop;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace EncoderDecoderUnitTest.Tests.GUI
{
    [TestClass]
    public class ProcessResourcesTest
    {
        AgentJoinRoomNotification notification;
        AgentJoinRoomNotification.Resources resources;
        CustomDesktop.UcChatWindow chatWindow;
        
        int agentId = 123;
        CustomDesktop.UcChatWindow.WindowType window = CustomDesktop.UcChatWindow.WindowType.NORMAL;

        [TestInitialize()]
        public void BeforeTest()
        {
            Globals.agentFirstName = "Frank";
            Globals.agentLastName = "Smith";
            notification = new AgentJoinRoomNotification();
            resources = notification.body.resources;
        }

        [TestMethod]
        public void ProcessResourcesTest_CustomerLabelString()
        {
            resources.agentLabel = "first name last name";
            resources.customerLabel = "customer";
            chatWindow = new CustomDesktop.UcChatWindow(agentId, window, notification);

            Assert.AreEqual(chatWindow.customerLabel, "[customer]");
        }

        [TestMethod]
        public void ProcessResourcesTest_CustomerLabelNumbers()
        {
            resources.agentLabel = "first name last name";
            resources.customerLabel = "123";
            chatWindow = new CustomDesktop.UcChatWindow(agentId, window, notification);

            Assert.AreEqual(chatWindow.customerLabel, "[123]");
        }

        [TestMethod]
        public void ProcessResourcesTest_CustomerLabelEmpty()
        {
            resources.agentLabel = "first name last name";
            resources.customerLabel = "";
            chatWindow = new CustomDesktop.UcChatWindow(agentId, window, notification);

            Assert.AreEqual(chatWindow.customerLabel, "[Customer(Defaulted)]");
        }

        [TestMethod]
        public void ProcessResourcesTest_AgentLabelFirstName()
        {
            resources.agentLabel = "Frank";
            resources.customerLabel = "customer";
            chatWindow = new CustomDesktop.UcChatWindow(agentId, window, notification);

            Assert.AreEqual(chatWindow.agentLabel, "[Frank]");
        }

        [TestMethod]
        public void ProcessResourcesTest_AgentLabelFirstNameLastName()
        {
            resources.agentLabel = "Frank Smith";
            resources.customerLabel = "customer";
            chatWindow = new CustomDesktop.UcChatWindow(agentId, window, notification);

            Assert.AreEqual(chatWindow.agentLabel, "[Frank Smith]");
        }

        [TestMethod]
        public void ProcessResourcesTest_AgentLabelLastNameFirstName()
        {
            resources.agentLabel = "Smith, Frank";
            resources.customerLabel = "customer";
            chatWindow = new CustomDesktop.UcChatWindow(agentId, window, notification);

            Assert.AreEqual(chatWindow.agentLabel, "[Smith, Frank]");
        }

        [TestMethod]
        public void ProcessResourcesTest_AgentLabelNull()
        {
            resources.customerLabel = "customer";
            chatWindow = new CustomDesktop.UcChatWindow(agentId, window, notification);

            Assert.AreEqual(chatWindow.agentLabel, "[Agent(Defaulted)]");
        }

        [TestMethod]
        public void ProcessResourcesTest_AgentLabelEmpty()
        {
            resources.agentLabel = "";
            resources.customerLabel = "customer";
            chatWindow = new CustomDesktop.UcChatWindow(agentId, window, notification);

            Assert.AreEqual(chatWindow.agentLabel, "[Agent(Defaulted)]");
        }

        [TestMethod]
        public void ProcessResourcesTest_NullNotification()
        {
            AgentJoinRoomNotification notificationEx = new AgentJoinRoomNotification();
            notificationEx = null;
            chatWindow = new CustomDesktop.UcChatWindow(agentId, window, notificationEx);

            Assert.AreEqual(chatWindow.agentLabel, "[Agent(Defaulted)]");
            Assert.AreEqual(chatWindow.customerLabel, "[Customer(Defaulted)]");
        }
    }
}
