﻿//////////////////////////////////////////////////////////////////////////////
// AgentActiveNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentActiveNotificationTest
    {
        [TestMethod]
        public void AgentActiveNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""activeAgentNotification"",
                                        ""guid"" : 12345,
                                        ""agentId"" : ""54321"",
                                        ""userType"" : ""observe""
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentActiveNotification note = (AgentActiveNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "activeAgentNotification");
            Assert.AreEqual(note.body.guid, 12345);
            Assert.AreEqual(note.body.agentId, "54321");
            Assert.AreEqual(note.body.userType, "observe");

        }

    }


}

