﻿//////////////////////////////////////////////////////////////////////////////
// AgentSetClosedReasonNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentSetClosedReasonNotificationTest
    {
        [TestMethod]
        public void AgentSetClosedReasonNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""agentSetClosedReason"",
                                        ""guid"" : 12345,
                                        ""accepted"" : true
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentSetClosedReasonNotification note = (AgentSetClosedReasonNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "agentSetClosedReason");
            Assert.AreEqual(note.body.guid, 12345);
            Assert.IsTrue(note.body.accepted);
        }

        [TestMethod]
        public void AgentSetClosedReasonNotificationTest_SimpleDecode2()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""agentSetClosedReason"",
                                        ""accepted"" : false
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentSetClosedReasonNotification note = (AgentSetClosedReasonNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "agentSetClosedReason");
            Assert.IsFalse(note.body.accepted); 
        }
    }
}
