﻿//////////////////////////////////////////////////////////////////////////////
// AgentLogoutRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentLogoutRequestTest
    {
        [TestMethod]
        public void AgentLogoutRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""agentLogout""}}";

            AgentLogoutRequest temp = new AgentLogoutRequest();
            temp.apiVersion = AgentLogoutRequest.JSapiVersion.one_point_zero;

            JEncoder e = new JEncoder();
            String response = e.Encode(temp);
            
            Assert.AreEqual(response, jsonExpected);

        }
    }
}
