﻿//////////////////////////////////////////////////////////////////////////////
// ICCTConnector.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using Nortel.CCT;
using System.Collections.Generic;
namespace CustomDesktop
{
    /// <summary>
    /// Interface that defines the main methods needed for communicating with CCT.
    /// </summary>
    public interface ICCTConnector
    {
        //Events      
        event contactReceived ContactReceived;
        event contactDropped ContactDropped;
        event consultContactReceived ConsultContactReceived;
        event consultCreated ConsultCreated;
        event conferenceComplete ConferenceComplete;
        event readyStateChanged ReadyStateChanged;
        event loginStateChanged LoginStateChanged;
        event transferComplete TransferComplete;
        event connectionStateChanged ConnectionStateChanged;
        event consultRejected ConsultRejected;
        event consultAccepted ConsultAccepted;

        //Actual methods
        ResultCode Connect(LoginControl.LoginDetails credentials);
        ResultCode Disconnect();
        ResultCode ToggleReady();
        ResultCode RejectContact(Contact contact);
        ResultCode AcceptContact(Contact contact);
        ResultCode InitiateConference(long contactID, long agentID);
        ResultCode BlindTransfer(long contactID, CDEntities.CDContactCentreSkillset skillset);
        ResultCode CompleteTransfer(Contact contact);
        ResultCode CompleteConference(Contact contact);
        ResultCode SetActiveContact(long contactID);
        ResultCode SetAgent(IAgent agent);
        ResultCode DisconnectConnection(long contactID);
        ResultCode RemoveConnection(long contactID);
        string GetAgentString();
        bool IsConnected();
        IAgent[] GetReceivedAgents();
        void AgentLogout();
        Contact GetContact(long contactID);
        void RemoveContact(long contactID);
        void AddObserveContact(long contactID, Contact contact);
        void RemoveObserveContact(long contactID);
        void DisconnectObserveConnection(long contactID);

        bool GetAgentIsReadyState();

        //debug
        List<ITerminal> DebugTerminals();
        Dictionary<long, ITerminalConnection> DebugTerminalConnections();
        Dictionary<long, Contact> DebugContacts();
    }

    //Delegates - must be defined outside of the interface.
    public delegate void connectionStateChanged(CustomDesktop.CCTConnector.CCTConnectionState state);
    public delegate void contactReceived(Contact contact);
    public delegate void contactDropped(long contactID);
    public delegate void consultContactReceived(Contact contact);
    public delegate void consultCreated(Contact contact);
    public delegate void conferenceComplete(Contact contact);
    public delegate void transferComplete(Contact contact);
    public delegate void readyStateChanged(ReadyStatusAgentProperty readyStatus);
    public delegate void loginStateChanged(LoginStatusAgentProperty loginStatus);
    public delegate void consultRejected(Contact contact);
    public delegate void consultAccepted(Contact contact);
}
