﻿//////////////////////////////////////////////////////////////////////////////
// ReadCustomerHistoryNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;

namespace EncoderDecoderUnitTest.Tests.Notifications
{
    [TestClass]
    public class ReadCustomerHistoryNotificationTest
    {
        [TestMethod]
        public void ReadCustomerHistoryNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""customerHistory"",
                                        ""guid"" : 443344,
                                        ""history"" : [
                                            {
                                                ""startTime"" : 45638485689,
                                                ""transcript"" : ""hello there""
                                            },
                                            {
                                                ""startTime"" : 54657688968,
                                                ""transcript"" : ""hello there, hi customer""
                                            },
                                            {
                                                ""startTime"" : 23456456678,
                                                ""transcript"" : ""help me""
                                            }
                                        ]
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            ReadCustomerHistoryNotification note = (ReadCustomerHistoryNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "customerHistory");
            Assert.AreEqual(note.body.guid, 443344);

            List<ReadCustomerHistoryNotification.History> hist = note.body.history;
            Assert.AreEqual(hist.Count, 3);

            Assert.AreEqual(hist[0].startTime, 45638485689);
            Assert.AreEqual(hist[0].transcript, "hello there");
            Assert.AreEqual(hist[1].startTime, 54657688968);
            Assert.AreEqual(hist[1].transcript, "hello there, hi customer");
            Assert.AreEqual(hist[2].startTime, 23456456678);
            Assert.AreEqual(hist[2].transcript, "help me");
            
        
        }
    }
}
