/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sslvpn;

import com.avaya.sslvpn.WebServiceApiAdapter;
import com.avaya.sslvpn.WebServiceResponseParser;
import com.avaya.sslvpn.sslvpnException;
import com.avaya.sslvpn.sslvpnOnboarding;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.PublicKey;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class sslvpnOnboardingExpress {
    private static final String CHARSET = "UTF-8";
    private String def_host = "192.168.42.1";
    private String def_admin_account = "Administrator";
    private String def_admin_password = "Administrator";
    private String host = "";
    private String admin_account = "";
    private String admin_password = "";
    private String soldto_num = "";
    private String vpn_name = "";
    private String vpn_account = "";
    private String vpn_password = "";
    private String vpn_server = "";
    private String default_template_file = "";
    private String inventory_file = "";
    private String properties_file = "";
    private String onboarding_file = "";
    private String log_file = "";
    private String file_prefix = "";
    private String zip_file = "";
    private String temporary_directory = "";
    private String results_directory = "";
    private BufferedReader in = null;

    private sslvpnOnboardingExpress() {
    }

    private void init() {
        this.host = "";
        this.admin_account = "";
        this.admin_password = "";
        this.soldto_num = "";
        this.vpn_name = "BP_SUPPORT";
        this.vpn_account = "";
        this.vpn_password = "";
        this.vpn_server = "";
        this.inventory_file = "";
        this.properties_file = "";
        this.onboarding_file = "";
        this.log_file = "";
        this.zip_file = "";
        this.default_template_file = "sslvpn_template.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void LogMsg(String string, String string2) {
        PrintWriter printWriter = null;
        File file = null;
        if (string2 == null) {
            return;
        }
        try {
            if (string2.isEmpty()) {
                return;
            }
            file = new File(string2);
            printWriter = new PrintWriter(file, CHARSET);
            printWriter.write(string);
            printWriter.write("\r\n");
            printWriter.flush();
        }
        catch (Exception exception) {
            System.out.println("Error in writing in LogMsg: " + exception.getMessage());
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Error in closing in LogMsg: " + exception.getMessage());
            }
        }
    }

    private static void PrintMsg(String string, StringBuilder stringBuilder, String string2) {
        if (stringBuilder != null) {
            stringBuilder.append(string);
        } else {
            System.out.println(string);
        }
        if (string2 != null) {
            sslvpnOnboardingExpress.LogMsg(string, string2);
        }
    }

    private static String GetRandomString(int n) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        while (n > 0) {
            Random random = new Random();
            stringBuilder.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJLMNOPQRSTUVWXYZ1234567890".charAt(random.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJLMNOPQRSTUVWXYZ1234567890".length())));
            --n;
        }
        return stringBuilder.toString();
    }

    private static String GenRandomPassword() {
        try {
            int[] nArray = new int[]{12, 13, 14, 15, 16};
            int n = 8;
            Random random = new Random();
            int n2 = random.nextInt(nArray.length);
            if (n2 >= 0 && n2 < nArray.length) {
                n = nArray[n2];
            }
            return sslvpnOnboardingExpress.GetRandomString(n);
        }
        catch (Exception exception) {
            System.out.println("ERROR: Exception generating random password.");
            return "Administrator";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean LoadParametersFile(String string) {
        BufferedReader bufferedReader = null;
        sslvpnOnboardingExpress.LogMsg("Loading parameters file = " + string, this.log_file);
        File file = new File(string);
        if (!file.exists()) {
            sslvpnOnboardingExpress.PrintMsg("Error in LoadParametersFile: cannot find: " + string, null, this.log_file);
            return false;
        }
        try {
            int n;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), CHARSET));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (!string2.startsWith("#") && (n = string2.indexOf(61)) != -1) {
                    String string3 = string2.substring(0, n).trim();
                    String string4 = string2.substring(n + 1).trim();
                    if (!string4.isEmpty()) {
                        if ("IP_OFFICE".equalsIgnoreCase(string3)) {
                            this.host = string4;
                        } else if ("ADMIN_ACCOUNT".equalsIgnoreCase(string3)) {
                            this.admin_account = string4;
                        } else if ("ADMIN_PASSWORD".equalsIgnoreCase(string3)) {
                            this.admin_password = string4;
                        } else if ("REF_NUM".equalsIgnoreCase(string3)) {
                            this.soldto_num = string4;
                        } else if ("VPN_NAME".equalsIgnoreCase(string3)) {
                            this.vpn_name = string4;
                        } else if ("VPN_ACCOUNT".equalsIgnoreCase(string3)) {
                            this.vpn_account = string4;
                        } else if ("VPN_PASSWORD".equalsIgnoreCase(string3)) {
                            this.vpn_password = string4;
                        } else if ("VPN_SERVER".equalsIgnoreCase(string3)) {
                            this.vpn_server = string4;
                        } else if ("TEMPLATE_FILE".equalsIgnoreCase(string3)) {
                            this.default_template_file = string4;
                        }
                    }
                }
                string2 = bufferedReader.readLine();
            }
            sslvpnOnboardingExpress.LogMsg("LoadParametersFile:" + string, this.log_file);
            sslvpnOnboardingExpress.LogMsg("LoadParametersFile:ip_office =" + this.host + "admin_account=" + this.admin_account + "admin_password=" + this.admin_password, this.log_file);
            sslvpnOnboardingExpress.LogMsg("LoadParametersFile:soldto =" + this.soldto_num + "vpn_account=" + this.vpn_account + "vpn_password=" + this.vpn_password, this.log_file);
            n = 1;
            return n != 0;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            sslvpnOnboardingExpress.PrintMsg("Error in reading in LoadParametersFile:" + exception.getMessage(), null, this.log_file);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                sslvpnOnboardingExpress.PrintMsg("Error in closing file in LoadParametersFile:" + iOException.getMessage(), null, this.log_file);
            }
        }
    }

    private boolean PromptReferenceNum() throws IOException {
        boolean bl = false;
        for (int i = 3; i > 0 && !bl; --i) {
            if (this.soldto_num.isEmpty()) {
                System.out.print("Enter Reference number: ");
            } else {
                System.out.print("Enter Reference number [" + this.soldto_num + "]: ");
            }
            String string = this.in.readLine();
            if (string != null && !string.isEmpty()) {
                this.soldto_num = string;
            }
            if (this.soldto_num.isEmpty()) {
                System.out.println("Error in Prompt Data: Reference number is required!");
                continue;
            }
            int n = this.soldto_num.length();
            if (n > 10) {
                System.out.println("Error: reference number cannot exceed 10 digits.");
                continue;
            }
            bl = true;
            for (int j = 0; j < n && bl; ++j) {
                if (Character.isDigit(this.soldto_num.charAt(j))) continue;
                System.out.println("Error: numeric Reference number expected!");
                bl = false;
            }
        }
        return bl;
    }

    private boolean PromptData() {
        try {
            String string = null;
            if (this.host.isEmpty() || this.admin_account.isEmpty() || this.admin_password.isEmpty() || this.soldto_num.isEmpty() || this.vpn_account.isEmpty() || this.vpn_password.isEmpty()) {
                if (this.host.isEmpty()) {
                    this.host = this.def_host;
                }
                System.out.print("Enter IP Office IP address [" + this.host + "]: ");
                string = this.in.readLine();
                if (string != null && !string.isEmpty()) {
                    this.host = string;
                }
                if (this.admin_account.isEmpty()) {
                    this.admin_account = this.def_admin_account;
                }
                System.out.print("Enter Admin Account [" + this.admin_account + "]: ");
                string = this.in.readLine();
                if (string != null && !string.isEmpty()) {
                    this.admin_account = string;
                }
                if (this.admin_password.isEmpty()) {
                    this.admin_password = this.def_admin_password;
                }
                System.out.print("Enter Admin Password [" + this.admin_password + "]: ");
                string = this.in.readLine();
                if (string != null && !string.isEmpty()) {
                    this.admin_password = string;
                }
                if (!this.PromptReferenceNum()) {
                    return false;
                }
                if (this.vpn_account.isEmpty()) {
                    this.vpn_account = this.soldto_num;
                }
                System.out.print("Enter VPN Account [" + this.vpn_account + "]: ");
                string = this.in.readLine();
                if (string != null && !string.isEmpty()) {
                    this.vpn_account = string;
                }
                if (this.vpn_password.isEmpty()) {
                    this.vpn_password = sslvpnOnboardingExpress.GenRandomPassword();
                }
                System.out.print("Please enter VPN Password [" + this.vpn_password + "]: ");
                string = this.in.readLine();
                if (string != null && !string.isEmpty()) {
                    this.vpn_password = string;
                }
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("Error in Prompt Data:" + exception.getMessage());
            return false;
        }
    }

    private boolean ConfirmToExit() {
        try {
            System.out.print("Press ENTER to continue");
            this.in.readLine();
        }
        catch (Exception exception) {
            return true;
        }
        return true;
    }

    private String GetFilePrefix() {
        int n = 1;
        File[] fileArray = new File(this.results_directory).listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!file.isFile() || !file.getName().startsWith(this.soldto_num)) continue;
                ++n;
            }
        }
        return this.soldto_num + "_" + Integer.toString(n) + "_";
    }

    private boolean make_dir(String string) {
        File file = new File(string);
        try {
            if (!file.exists() && !file.mkdir()) {
                sslvpnOnboardingExpress.PrintMsg("Failed to create directory: " + string, null, this.log_file);
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            sslvpnOnboardingExpress.PrintMsg("make_dir: failed to create directory:" + string, null, this.log_file);
            return false;
        }
    }

    private boolean SetupFileNamesAndDirs() {
        this.temporary_directory = System.getProperty("user.dir") + System.getProperty("file.separator") + "sslvpn_TEMP";
        this.results_directory = System.getProperty("user.dir") + System.getProperty("file.separator") + "sslvpn_OUTPUT";
        if (!this.make_dir(this.temporary_directory)) {
            return false;
        }
        if (!this.make_dir(this.results_directory)) {
            return false;
        }
        this.file_prefix = this.GetFilePrefix();
        this.inventory_file = this.temporary_directory + System.getProperty("file.separator") + this.file_prefix + "inventory.xml";
        this.properties_file = this.temporary_directory + System.getProperty("file.separator") + this.file_prefix + "sslvpn.properties";
        this.onboarding_file = this.temporary_directory + System.getProperty("file.separator") + this.file_prefix + "sslvpn_onboarding.xml";
        this.log_file = this.temporary_directory + System.getProperty("file.separator") + this.file_prefix + "logs.txt";
        return true;
    }

    private void DeleteTempFile(String string) {
        try {
            File file = new File(string);
            if (file.exists() && file.canWrite() && !file.delete()) {
                sslvpnOnboardingExpress.PrintMsg("Failed to delete temp file: " + string, null, this.log_file);
            }
        }
        catch (Exception exception) {
            sslvpnOnboardingExpress.PrintMsg("Error in DeleteTempFile: " + exception.getMessage(), null, this.log_file);
        }
    }

    private void DeleteTempFiles() {
        this.DeleteTempFile(this.inventory_file);
        this.DeleteTempFile(this.properties_file);
        this.DeleteTempFile(this.onboarding_file);
        this.DeleteTempFile(this.log_file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean BuildPropertiesFile() {
        PrintWriter printWriter = null;
        try {
            if (this.properties_file.isEmpty()) {
                sslvpnOnboardingExpress.PrintMsg("Error in Build Properties File: filename is not set!", null, this.log_file);
                boolean bl = false;
                return bl;
            }
            File file = new File(this.properties_file);
            if (file.exists()) {
                if (!file.canWrite()) {
                    sslvpnOnboardingExpress.PrintMsg("Error in Build Properties File: " + this.properties_file + " is write protected.", null, this.log_file);
                    boolean bl = false;
                    return bl;
                }
                if (!file.delete()) {
                    sslvpnOnboardingExpress.PrintMsg("Failed to delete old properties file: " + this.properties_file, null, this.log_file);
                    boolean bl = false;
                    return bl;
                }
            }
            printWriter = new PrintWriter(this.properties_file, CHARSET);
            printWriter.write("#sslvpn.properties for " + this.host + "\r\n");
            printWriter.write("#\r\n");
            printWriter.write("soldto=" + this.soldto_num + "\r\n");
            printWriter.write("# \r\n");
            if (!this.vpn_server.isEmpty()) {
                printWriter.write("VPN_Service.ServerAddress=" + this.vpn_server + "\r\n");
            }
            printWriter.write("VPN_Service.Name=" + this.vpn_name + "\r\n");
            printWriter.write("VPN_Service.AccountName=" + this.vpn_account + "\r\n");
            printWriter.write("VPN_Service.Password=" + this.vpn_password + "\r\n");
            sslvpnOnboardingExpress.PrintMsg("Successfully built SSLVPN properties file", null, this.log_file);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            sslvpnOnboardingExpress.PrintMsg("Error in writing in Build Properties File: " + exception.getMessage(), null, this.log_file);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                sslvpnOnboardingExpress.PrintMsg("Error in closing in Build Properties File: " + exception.getMessage(), null, this.log_file);
            }
        }
    }

    public static boolean GetInventory(String string, String string2, String string3, String string4, String string5, StringBuilder stringBuilder) {
        try {
            WebServiceApiAdapter webServiceApiAdapter = new WebServiceApiAdapter(string2, string3);
            sslvpnOnboardingExpress.LogMsg("Getting Inventory; ip_office=" + string + "; ID=" + string2 + "; PW=" + string3, string5);
            File file = new File(string4);
            if (file.exists()) {
                if (!file.canWrite()) {
                    sslvpnOnboardingExpress.PrintMsg("Error in Get Inventory: " + string4 + " is write protected.", stringBuilder, string5);
                    return false;
                }
                if (!file.delete()) {
                    sslvpnOnboardingExpress.PrintMsg("Failed to delete old inventory file: " + string4, stringBuilder, string5);
                    return false;
                }
            }
            webServiceApiAdapter.invokeAction("GET<TO>https://<HOST>:8443/ws/inventory.xml", string, file, new String[0]);
            file = new File(string4);
            if (file.exists() && file.length() > 0L) {
                sslvpnOnboardingExpress.PrintMsg("Successfully retrieved inventory file: " + string4, stringBuilder, string5);
                return true;
            }
            sslvpnOnboardingExpress.PrintMsg("Failed to get inventory.", stringBuilder, string5);
            return false;
        }
        catch (Exception exception) {
            sslvpnOnboardingExpress.PrintMsg("Error in GetInventory: " + exception.getMessage(), stringBuilder, string5);
            return false;
        }
    }

    private boolean GetInventoryInternal() {
        return sslvpnOnboardingExpress.GetInventory(this.host, this.admin_account, this.admin_password, this.inventory_file, this.log_file, null);
    }

    private boolean SignOnboardingFile() {
        try {
            String string = System.getProperty("user.dir") + System.getProperty("file.separator") + "templates" + System.getProperty("file.separator") + this.default_template_file;
            sslvpnOnboardingExpress.LogMsg("Signing file; template = " + string, this.log_file);
            File file = new File(string);
            if (!file.exists()) {
                sslvpnOnboardingExpress.PrintMsg("Error template missing! Could not find: " + string, null, this.log_file);
                return false;
            }
            PublicKey publicKey = sslvpnOnboarding.initPubKey(this.inventory_file, null);
            if (publicKey != null) {
                sslvpnOnboarding.generateSSLVPN(publicKey, string, this.onboarding_file, this.properties_file, this.vpn_server.isEmpty());
                sslvpnOnboardingExpress.PrintMsg("Successfully signed onboarding file.", null, this.log_file);
                return true;
            }
            sslvpnOnboardingExpress.PrintMsg("Error in Sign OnBoarding File: cannot initialize public key", null, this.log_file);
            return false;
        }
        catch (sslvpnException sslvpnException2) {
            sslvpnOnboardingExpress.PrintMsg("Error in Sign OnBoarding File: " + sslvpnException2.getMessage(), null, this.log_file);
            return false;
        }
        catch (Exception exception) {
            sslvpnOnboardingExpress.PrintMsg("Error in Sign OnBoarding File: " + exception.getMessage(), null, this.log_file);
            return false;
        }
    }

    public static boolean SendOnBoardingFile(String string, String string2, String string3, String string4, String string5, StringBuilder stringBuilder) {
        try {
            File file = new File(string4);
            String string6 = file.getName();
            WebServiceApiAdapter webServiceApiAdapter = new WebServiceApiAdapter(string2, string3);
            WebServiceResponseParser webServiceResponseParser = new WebServiceResponseParser();
            File file2 = new File(string4);
            String string7 = webServiceApiAdapter.invokeAction("POST<TO>https://<HOST>:8443/ws/filesys?type=file&file=" + string6, string, file2, new String[0]);
            if (string7 == null) {
                sslvpnOnboardingExpress.PrintMsg("Failed to send onboarding file to IP Office " + string + ", response is null", stringBuilder, string5);
                return false;
            }
            sslvpnOnboardingExpress.LogMsg("Pushing Onboarding File; Response = \r\n" + string7, string5);
            String string8 = webServiceResponseParser.parseWebServiceResponseStatus(string7, "//response/@status");
            if (string8 == null) {
                sslvpnOnboardingExpress.PrintMsg("Failed to send onboarding file, cannot parse response code.", null, string5);
                return false;
            }
            if (string8.equals("1")) {
                sslvpnOnboardingExpress.PrintMsg("Successfully sent onboarding file to IP Office " + string + ": target filename = " + string6, null, string5);
                return true;
            }
            sslvpnOnboardingExpress.PrintMsg("Failed to send onboarding file to IP Office " + string + ".", null, string5);
            return false;
        }
        catch (Exception exception) {
            sslvpnOnboardingExpress.PrintMsg("Error in SendOnBoardingFile: " + exception.getMessage(), null, string5);
            return false;
        }
    }

    private boolean SendOnBoardingFileInternal() {
        return sslvpnOnboardingExpress.SendOnBoardingFile(this.host, this.admin_account, this.admin_password, this.onboarding_file, this.log_file, null);
    }

    public static boolean ApplyOnboarding(String string, String string2, String string3, String string4, String string5, StringBuilder stringBuilder) {
        try {
            File file = new File(string4);
            String string6 = file.getName();
            WebServiceApiAdapter webServiceApiAdapter = new WebServiceApiAdapter(string2, string3);
            WebServiceResponseParser webServiceResponseParser = new WebServiceResponseParser();
            String string7 = webServiceApiAdapter.invokeAction("POST<TO>https://<HOST>:8443/ws/admin/on_boarding?file=" + string6, string);
            if (string7 == null) {
                sslvpnOnboardingExpress.PrintMsg("Failed to apply onboarding file, response code is null.", stringBuilder, string5);
                return false;
            }
            sslvpnOnboardingExpress.LogMsg("Invoked Apply Onboarding; Response = \r\n" + string7, string5);
            String string8 = webServiceResponseParser.parseWebServiceResponseStatus(string7, "//response/@status");
            if (string8 == null) {
                sslvpnOnboardingExpress.PrintMsg("Failed to decode onboarding response message.", stringBuilder, string5);
                return false;
            }
            if (string8.equals("1")) {
                sslvpnOnboardingExpress.PrintMsg("Successfully onboarded.", stringBuilder, string5);
                return true;
            }
            sslvpnOnboardingExpress.PrintMsg("Failed to apply onboarding xml file.", stringBuilder, string5);
            return false;
        }
        catch (Exception exception) {
            sslvpnOnboardingExpress.PrintMsg("Error in ApplyOnboarding: " + exception.getMessage(), stringBuilder, string5);
            return false;
        }
    }

    private boolean ApplyOnboardingInternal() {
        return sslvpnOnboardingExpress.ApplyOnboarding(this.host, this.admin_account, this.admin_password, this.onboarding_file, this.log_file, null);
    }

    private void ZipAFile(ZipOutputStream zipOutputStream, File file) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            zipOutputStream.putNextEntry(new ZipEntry(file.getName()));
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[4092];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
                System.out.print('.');
                System.out.flush();
            }
            System.out.println();
            zipOutputStream.closeEntry();
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ZipOutput() {
        ZipOutputStream zipOutputStream = null;
        String string = this.results_directory + System.getProperty("file.separator") + this.zip_file;
        sslvpnOnboardingExpress.PrintMsg("Zipping output to: " + string, null, this.log_file);
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            zipOutputStream.setLevel(-1);
            File file = new File(this.log_file);
            File file2 = new File(this.inventory_file);
            File file3 = new File(this.properties_file);
            File file4 = new File(this.onboarding_file);
            if (file.exists()) {
                this.ZipAFile(zipOutputStream, file);
            }
            if (file2.exists()) {
                this.ZipAFile(zipOutputStream, file2);
            }
            if (file3.exists()) {
                this.ZipAFile(zipOutputStream, file3);
            }
            if (file4.exists()) {
                this.ZipAFile(zipOutputStream, file4);
            }
            zipOutputStream.flush();
        }
        catch (Exception exception) {
            sslvpnOnboardingExpress.PrintMsg("Error in ZIP output: " + exception.getMessage(), null, this.log_file);
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (Exception exception) {
                sslvpnOnboardingExpress.PrintMsg("Error in ZIP file close: " + exception.getMessage(), null, this.log_file);
            }
        }
    }

    private static void PrintUsage() {
        System.out.println("sslvpnOnboardingExpress - 9.1.0.0 build 435");
        System.out.println("Automatically configures an IPOFFICE system for secure access through SSL VPN.\r\n");
        System.out.println("Usage: sslvpnOnboardingExpress [-f <file>] [-nopause]\r\n");
        System.out.println("       -f <file>: Specifies a TEXT file containing default startup parameters.");
        System.out.println("                  'default_parameters.txt' is an example parameters file.");
        System.out.println("                  This file supports the following parameters:");
        System.out.println("                      IP_OFFICE       =<IP Office fqdn/IP address>");
        System.out.println("                      ADMIN_ACCOUNT   =<Administrator account name>");
        System.out.println("                      ADMIN_PASSWORD  =<Administrator account password>");
        System.out.println("                      REF_NUM          =<Reference Number of the onboarding session.>");
        System.out.println("                      VPN_SERVER       =<Avaya VPN Gateway Server Address.>");
        System.out.println("                      VPN_NAME        =<Service Name - used to display info about the VPN service>");
        System.out.println("                      VPN_ACCOUNT     =<AVG (Avaya VPN Gateway) Account name>");
        System.out.println("                      VPN_PASSWORD    =<AVG Account password>");
        System.out.println("                  Some or all of the above parameters may be specified in the file.");
        System.out.println("                  Example file contents:");
        System.out.println("                      IP_OFFICE=192.168.137.29");
        System.out.println("                      ADMIN_ACCOUNT=Administrator");
        System.out.println("                      ADMIN_PASSWORD=Administrator");
        System.out.println("                      REF_NUM=100");
        System.out.println("                      VPN_SERVER=example_AVG_name.com");
        System.out.println("                      VPN_Name=BP_Support");
        System.out.println("                      VPN_ACCOUNT=SA1");
        System.out.println("                      VPN_PASSWORD=sa1");
        System.out.println("       -nopause : Do not pause; useful when combining this utility with other scripts.");
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        boolean bl = true;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            if ("-help".equalsIgnoreCase(stringArray[n]) || "-?".equalsIgnoreCase(stringArray[n])) {
                sslvpnOnboardingExpress.PrintUsage();
                System.exit(0);
                continue;
            }
            if ("-f".equalsIgnoreCase(stringArray[n])) {
                if (n + 1 >= n2) continue;
                string = stringArray[++n];
                continue;
            }
            if ("-nopause".equalsIgnoreCase(stringArray[n])) {
                bl = false;
                continue;
            }
            sslvpnOnboardingExpress.PrintUsage();
            System.exit(1);
        }
        n = 0;
        sslvpnOnboardingExpress sslvpnOnboardingExpress2 = new sslvpnOnboardingExpress();
        sslvpnOnboardingExpress2.init();
        try {
            sslvpnOnboardingExpress2.in = new BufferedReader(new InputStreamReader(System.in, CHARSET));
            if (sslvpnOnboardingExpress2.in == null) {
                System.out.println("Unable to read from console.");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to read from console: " + exception.getMessage());
            System.exit(1);
        }
        if (string != null) {
            sslvpnOnboardingExpress2.LoadParametersFile(string);
        }
        if (sslvpnOnboardingExpress2.PromptData()) {
            if (sslvpnOnboardingExpress2.SetupFileNamesAndDirs() && sslvpnOnboardingExpress2.BuildPropertiesFile() && sslvpnOnboardingExpress2.GetInventoryInternal() && sslvpnOnboardingExpress2.SignOnboardingFile() && sslvpnOnboardingExpress2.SendOnBoardingFileInternal() && sslvpnOnboardingExpress2.ApplyOnboardingInternal()) {
                n = 1;
            }
            if (n == 1) {
                sslvpnOnboardingExpress2.zip_file = sslvpnOnboardingExpress2.file_prefix + "ONBOARDED" + ".zip";
                sslvpnOnboardingExpress2.ZipOutput();
                string2 = "SUCCESS. Data saved in " + sslvpnOnboardingExpress2.zip_file;
            } else {
                sslvpnOnboardingExpress2.zip_file = sslvpnOnboardingExpress2.file_prefix + "FAILED" + ".zip";
                sslvpnOnboardingExpress2.ZipOutput();
                string2 = "FAILED. Logs saved in " + sslvpnOnboardingExpress2.zip_file;
            }
            sslvpnOnboardingExpress2.DeleteTempFiles();
            System.out.println(string2);
        }
        if (!bl) {
            System.exit(0);
        }
        if (sslvpnOnboardingExpress2.ConfirmToExit()) {
            System.exit(0);
        }
    }
}

