package com.avaya.oceanareferenceclient.application;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class LogcatMonitorService extends Service {

    private static final String TAG = "LogcatMonitorService";
    private static final String SOCKET_LOG_MESSAGE = "CHTTPFromTextConverter::ConvertFromText():";


    private static final String INCOMING_HOLD_LOG_MESSAGE = "INCOMING_HOLD";
    private static final String INCOMING_UNHOLD_LOG_MESSAGE = "INCOMING_UNHOLD";

    private volatile boolean isMonitoring = false;

    private Thread monitorThread;

    @Override
    public void onCreate() {
        super.onCreate();
        Log.d(TAG, "LogcatMonitorService created");
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        startMonitoring();
        return START_STICKY;
    }

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        stopMonitoring();
        Log.d(TAG, "LogcatMonitorService destroyed");
    }

    private void startMonitoring() {
        if (isMonitoring) {
            return;
        }

        isMonitoring = true;

        monitorThread = new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    Process process = Runtime.getRuntime().exec("logcat -v threadtime");
                    BufferedReader bufferedReader = new BufferedReader(
                            new InputStreamReader(process.getInputStream()));

                    String line;
                    while (isMonitoring && (line = bufferedReader.readLine()) != null) {
                        if (line.contains(SOCKET_LOG_MESSAGE) && line.contains(INCOMING_HOLD_LOG_MESSAGE)) {
                            Log.d(TAG, "Detected incoming hold ");

                            // Trigger hold event or action here
                            // For example, you can broadcast an intent
                            // or send a local broadcast
                            // Example:
                            // Intent intent = new Intent("com.example.LOG_EVENT");
                            // intent.putExtra("logMessage", line);
                            // LocalBroadcastManager.getInstance(getApplicationContext()).sendBroadcast(intent);
                        }
                        if (line.contains(SOCKET_LOG_MESSAGE) && line.contains(INCOMING_UNHOLD_LOG_MESSAGE)) {
                            Log.d(TAG, "Detected incoming unhold ");

                            // Trigger unhold event or action here
                                                   }
                    }
                } catch (IOException e) {
                    Log.e(TAG, "Error reading logcat", e);
                }
            }
        });

        monitorThread.start();
    }

    private void stopMonitoring() {
        isMonitoring = false;
        if (monitorThread != null) {
            monitorThread.interrupt();
        }
    }
}