//
//  OceanaReferenceClientTests.m
//  OceanaReferenceClientTests
//
//  Created by Mohan on 06/04/20.
//  Copyright © 2020 Avaya. All rights reserved.
//



#import <XCTest/XCTest.h>
#import <OceanaCustomerWebVoiceVideo/OceanaCustomerWebVoiceVideo.h>

#import "WorkConfig.h"

@interface OceanaReferenceClientTests : XCTestCase

@end

@implementation OceanaReferenceClientTests

- (void)setUp {
    // Put setup code here. This method is called before the invocation of each test method in the class.
}

- (void)tearDown {
    // Put teardown code here. This method is called after the invocation of each test method in the class.
}

- (void)testExample {
    // This is an example of a functional test case.
    // Use XCTAssert and related functions to verify your tests produce the correct results.
}

- (void)testPerformanceExample {
    // This is an example of a performance test case.
    [self measureBlock:^{
        // Put the code you want to measure the time of here.
    }];
}

-(void) testOceanaVideoCall {
    
   __block AOOceanaCustomerWebVoiceVideo *videoCustomer;
    __block AOWork *videoWork;
    __block AOVideoInteraction *video;
    __block WorkConfig *workConfiguration;
    __block AOClientConfiguration* clientConfiguration;
    
    XCTestExpectation * expectation = [self expectationWithDescription:@"Check if AOPlatFormType_OCEANA Can be set"];
    
    NSDictionary *jsonPayload;
    NSString* loginUrlFormatString = @"%@://%@:%i/%@";
    
    NSString* port = @"443";
    NSString* protocol = @"https";
    NSString* urlPath = @"token-generation-service/token/getEncryptedToken";
    NSString*url = [NSString stringWithFormat:loginUrlFormatString, protocol, @"pusntzd205.apac.avaya.com", [port intValue], urlPath];
    
    NSString *displayName = @"Oceana";
    NSString *fromAddress = @"";
        
    NSMutableDictionary *requestPayload = [[NSMutableDictionary alloc]init];
    
    [requestPayload setObject:@"csaGuest" forKey:@"use"];
    [requestPayload setObject:displayName forKey:@"displayName"];
    [requestPayload setObject:fromAddress forKey:@"callingNumber"];
    [requestPayload setObject:@"120000" forKey:@"expiration"];
    
    jsonPayload = [NSDictionary dictionaryWithDictionary:requestPayload];
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:jsonPayload options:NSJSONWritingPrettyPrinted error:nil];
    
    NSMutableURLRequest *request = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString:url]];
    [request setTimeoutInterval:5.0]; // Test app, so timeout quickly...
    [request setValue:@"application/vnd.avaya.csa.tokens.v1+json" forHTTPHeaderField:@"Content-Type"];
    [request setValue:@"application/vnd.avaya.csa.tokens.v1+json" forHTTPHeaderField:@"Accept"];
    request.HTTPBody =jsonData;
    request.HTTPMethod = @"POST";
        
    NSURLSession *session = [NSURLSession sharedSession];
    NSURLSessionDataTask *task = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
        if ([response isKindOfClass:[NSHTTPURLResponse class]]) {
             workConfiguration = [[WorkConfig alloc]init];
            
            NSMutableDictionary *tokenDict = [NSJSONSerialization JSONObjectWithData:data options:0 error:nil];
            NSString *token = [tokenDict objectForKey:@"encryptedToken"];
                
            AOConfiguration* config = [[AOConfiguration alloc]init];
               config.restUrl = @"pusntzd195.apac.avaya.com";
               config.port = @"443";
               config.isSecure = YES;
               config.urlPath = @"services/AvayaMobileCommunications/sessions";
               
               AOWebGatewayConfiguration* webGatewayConfig = [[AOWebGatewayConfiguration alloc]init];
               webGatewayConfig.webGatewayAddress = @"pusntzd205.apac.avaya.com";
               webGatewayConfig.port = @"443";
               webGatewayConfig.isSecure = YES;
               webGatewayConfig.webGatewayUrlPath = @"csa/resources/tenants/default";
               
               
               clientConfiguration = [[AOClientConfiguration alloc]init];
               clientConfiguration.configuration = config;
               clientConfiguration.webGatewayConfiguration = webGatewayConfig;
            
                videoWork.context = @"Context";
                videoWork.locale = @"en_us";
                videoWork.routingStrategy = @"MOST_IDLE";
                videoWork.services = [workConfiguration serviceMapBuilder];
                videoWork.resources = [workConfiguration resourceMapBuilder];
            
                videoCustomer = [[AOOceanaCustomerWebVoiceVideo alloc]initWithClientConfiguration:clientConfiguration];
                videoWork = videoCustomer.createWork;
                videoWork.context = @"Customer"; //Here will be context
                video = videoWork.createVideoInteraction;
                video.authorizationToken = token;
            [video setPlatformType: AOPlatFormType_OCEANA];
            //            video.destinationAddress = @"";
            [video start];
            
            sleep(10);
            [expectation fulfill];
        }
    }];
    [task resume];
        
    [self waitForExpectationsWithTimeout:120.0 handler:nil];
}


-(void) testEliteVideoCall {
    
   __block AOOceanaCustomerWebVoiceVideo *videoCustomer;
    __block AOWork *videoWork;
    __block AOVideoInteraction *video;
    __block WorkConfig *workConfiguration;
    __block AOClientConfiguration* clientConfiguration;
    
    XCTestExpectation * expectation = [self expectationWithDescription:@"Check if AOPlatFormType_ELITE Can be set"];
    
    NSDictionary *jsonPayload;
    NSString* loginUrlFormatString = @"%@://%@:%i/%@";
    
    NSString* port = @"443";
    NSString* protocol = @"https";
    NSString* urlPath = @"token-generation-service/token/getEncryptedToken";
    NSString*url = [NSString stringWithFormat:loginUrlFormatString, protocol, @"pusntzd205.apac.avaya.com", [port intValue], urlPath];
    
    NSString *displayName = @"Oceana";
    NSString *fromAddress = @"";
        
    NSMutableDictionary *requestPayload = [[NSMutableDictionary alloc]init];
    
    [requestPayload setObject:@"csaGuest" forKey:@"use"];
    [requestPayload setObject:displayName forKey:@"displayName"];
    [requestPayload setObject:fromAddress forKey:@"callingNumber"];
    [requestPayload setObject:@"120000" forKey:@"expiration"];
    
    jsonPayload = [NSDictionary dictionaryWithDictionary:requestPayload];
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:jsonPayload options:NSJSONWritingPrettyPrinted error:nil];
    
    NSMutableURLRequest *request = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString:url]];
    [request setTimeoutInterval:5.0]; // Test app, so timeout quickly...
    [request setValue:@"application/vnd.avaya.csa.tokens.v1+json" forHTTPHeaderField:@"Content-Type"];
    [request setValue:@"application/vnd.avaya.csa.tokens.v1+json" forHTTPHeaderField:@"Accept"];
    request.HTTPBody =jsonData;
    request.HTTPMethod = @"POST";
        
    NSURLSession *session = [NSURLSession sharedSession];
    NSURLSessionDataTask *task = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
        if ([response isKindOfClass:[NSHTTPURLResponse class]]) {
             workConfiguration = [[WorkConfig alloc]init];
            
            NSMutableDictionary *tokenDict = [NSJSONSerialization JSONObjectWithData:data options:0 error:nil];
            NSString *token = [tokenDict objectForKey:@"encryptedToken"];
                
            AOConfiguration* config = [[AOConfiguration alloc]init];
               config.restUrl = @"pusntzd195.apac.avaya.com";
               config.port = @"443";
               config.isSecure = YES;
               config.urlPath = @"services/AvayaMobileCommunications/sessions";
               
               AOWebGatewayConfiguration* webGatewayConfig = [[AOWebGatewayConfiguration alloc]init];
               webGatewayConfig.webGatewayAddress = @"pusntzd205.apac.avaya.com";
               webGatewayConfig.port = @"443";
               webGatewayConfig.isSecure = YES;
               webGatewayConfig.webGatewayUrlPath = @"csa/resources/tenants/default";
               
               
               clientConfiguration = [[AOClientConfiguration alloc]init];
               clientConfiguration.configuration = config;
               clientConfiguration.webGatewayConfiguration = webGatewayConfig;
            
                videoWork.context = @"Context";
                videoWork.locale = @"en_us";
                videoWork.routingStrategy = @"MOST_IDLE";
                videoWork.services = [workConfiguration serviceMapBuilder];
                videoWork.resources = [workConfiguration resourceMapBuilder];
            
                videoCustomer = [[AOOceanaCustomerWebVoiceVideo alloc]initWithClientConfiguration:clientConfiguration];
                videoWork = videoCustomer.createWork;
                videoWork.context = @"Customer"; //Here will be context
                video = videoWork.createVideoInteraction;
                video.authorizationToken = token;
            [video setPlatformType: AOPlatFormType_ELITE];
            video.destinationAddress = @"450151";
            [video start];
            
            sleep(10);
            [expectation fulfill];
        }
    }];
    [task resume];
        
    [self waitForExpectationsWithTimeout:120.0 handler:nil];
}


-(void) testOceanaAudioCall {
    
    __block AOOceanaCustomerWebVoiceVideo *videoCustomer;
     __block AOWork *videoWork;
     __block AOAudioInteraction *audio;
     __block WorkConfig *workConfiguration;
     __block AOClientConfiguration* clientConfiguration;
     
     XCTestExpectation * expectation = [self expectationWithDescription:@"AWG Token service"];
     
     NSDictionary *jsonPayload;
     NSString* loginUrlFormatString = @"%@://%@:%i/%@";
     
     NSString* port = @"443";
     NSString* protocol = @"https";
     NSString* urlPath = @"token-generation-service/token/getEncryptedToken";
     NSString*url = [NSString stringWithFormat:loginUrlFormatString, protocol, @"pusntzd205.apac.avaya.com", [port intValue], urlPath];
     
     NSString *displayName = @"Oceana";
     NSString *fromAddress = @"";
         
     NSMutableDictionary *requestPayload = [[NSMutableDictionary alloc]init];
     
     [requestPayload setObject:@"csaGuest" forKey:@"use"];
     [requestPayload setObject:displayName forKey:@"displayName"];
     [requestPayload setObject:fromAddress forKey:@"callingNumber"];
     [requestPayload setObject:@"120000" forKey:@"expiration"];
     
     jsonPayload = [NSDictionary dictionaryWithDictionary:requestPayload];
     NSData *jsonData = [NSJSONSerialization dataWithJSONObject:jsonPayload options:NSJSONWritingPrettyPrinted error:nil];
     
     NSMutableURLRequest *request = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString:url]];
     [request setTimeoutInterval:5.0]; // Test app, so timeout quickly...
     [request setValue:@"application/vnd.avaya.csa.tokens.v1+json" forHTTPHeaderField:@"Content-Type"];
     [request setValue:@"application/vnd.avaya.csa.tokens.v1+json" forHTTPHeaderField:@"Accept"];
     request.HTTPBody =jsonData;
     request.HTTPMethod = @"POST";
         
     NSURLSession *session = [NSURLSession sharedSession];
     NSURLSessionDataTask *task = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
         if ([response isKindOfClass:[NSHTTPURLResponse class]]) {
              workConfiguration = [[WorkConfig alloc]init];
             
             NSMutableDictionary *tokenDict = [NSJSONSerialization JSONObjectWithData:data options:0 error:nil];
             NSString *token = [tokenDict objectForKey:@"encryptedToken"];
                 
             AOConfiguration* config = [[AOConfiguration alloc]init];
                config.restUrl = @"pusntzd195.apac.avaya.com";
                config.port = @"443";
                config.isSecure = YES;
                config.urlPath = @"services/AvayaMobileCommunications/sessions";
                
                AOWebGatewayConfiguration* webGatewayConfig = [[AOWebGatewayConfiguration alloc]init];
                webGatewayConfig.webGatewayAddress = @"pusntzd205.apac.avaya.com";
                webGatewayConfig.port = @"443";
                webGatewayConfig.isSecure = YES;
                webGatewayConfig.webGatewayUrlPath = @"csa/resources/tenants/default";
                
                
                clientConfiguration = [[AOClientConfiguration alloc]init];
                clientConfiguration.configuration = config;
                clientConfiguration.webGatewayConfiguration = webGatewayConfig;
             
                 videoWork.context = @"Context";
                 videoWork.locale = @"en_us";
                 videoWork.routingStrategy = @"MOST_IDLE";
                 videoWork.services = [workConfiguration serviceMapBuilder];
                 videoWork.resources = [workConfiguration resourceMapBuilder];
             
                 videoCustomer = [[AOOceanaCustomerWebVoiceVideo alloc]initWithClientConfiguration:clientConfiguration];
                 videoWork = videoCustomer.createWork;
                 videoWork.context = @"Customer"; //Here will be context
                 audio = videoWork.createAudioInteraction;
             audio.authorizationToken = token;
             [audio setPlatformType:AOPlatFormType_OCEANA];
             [audio start];
             
             sleep(10);
             
             [audio readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
                 NSLog(@"#Test Audio Details : %@", audioDetails);
                 if (audioDetails && [audioDetails isKindOfClass:[AOAudioDetails class]]) {
                     [expectation fulfill];
                 } else {
                     XCTAssert(audioDetails, @"Not valid Audio Details");
                 }
             }];
         }
     }];
     [task resume];
         
     [self waitForExpectationsWithTimeout:120.0 handler:nil];
}


-(void) testEliteAudioCall {
    
    __block AOOceanaCustomerWebVoiceVideo *videoCustomer;
     __block AOWork *videoWork;
     __block AOAudioInteraction *audio;
     __block WorkConfig *workConfiguration;
     __block AOClientConfiguration* clientConfiguration;
     
     XCTestExpectation * expectation = [self expectationWithDescription:@"AWG Token service"];
     
     NSDictionary *jsonPayload;
     NSString* loginUrlFormatString = @"%@://%@:%i/%@";
     
     NSString* port = @"443";
     NSString* protocol = @"https";
     NSString* urlPath = @"token-generation-service/token/getEncryptedToken";
     NSString*url = [NSString stringWithFormat:loginUrlFormatString, protocol, @"pusntzd205.apac.avaya.com", [port intValue], urlPath];
     
     NSString *displayName = @"Oceana";
     NSString *fromAddress = @"";
         
     NSMutableDictionary *requestPayload = [[NSMutableDictionary alloc]init];
     
     [requestPayload setObject:@"csaGuest" forKey:@"use"];
     [requestPayload setObject:displayName forKey:@"displayName"];
     [requestPayload setObject:fromAddress forKey:@"callingNumber"];
     [requestPayload setObject:@"120000" forKey:@"expiration"];
     
     jsonPayload = [NSDictionary dictionaryWithDictionary:requestPayload];
     NSData *jsonData = [NSJSONSerialization dataWithJSONObject:jsonPayload options:NSJSONWritingPrettyPrinted error:nil];
     
     NSMutableURLRequest *request = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString:url]];
     [request setTimeoutInterval:5.0]; // Test app, so timeout quickly...
     [request setValue:@"application/vnd.avaya.csa.tokens.v1+json" forHTTPHeaderField:@"Content-Type"];
     [request setValue:@"application/vnd.avaya.csa.tokens.v1+json" forHTTPHeaderField:@"Accept"];
     request.HTTPBody =jsonData;
     request.HTTPMethod = @"POST";
         
     NSURLSession *session = [NSURLSession sharedSession];
     NSURLSessionDataTask *task = [session dataTaskWithRequest:request completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
         if ([response isKindOfClass:[NSHTTPURLResponse class]]) {
              workConfiguration = [[WorkConfig alloc]init];
             
             NSMutableDictionary *tokenDict = [NSJSONSerialization JSONObjectWithData:data options:0 error:nil];
             NSString *token = [tokenDict objectForKey:@"encryptedToken"];
                 
             AOConfiguration* config = [[AOConfiguration alloc]init];
                config.restUrl = @"pusntzd195.apac.avaya.com";
                config.port = @"443";
                config.isSecure = YES;
                config.urlPath = @"services/AvayaMobileCommunications/sessions";
                
                AOWebGatewayConfiguration* webGatewayConfig = [[AOWebGatewayConfiguration alloc]init];
                webGatewayConfig.webGatewayAddress = @"pusntzd205.apac.avaya.com";
                webGatewayConfig.port = @"443";
                webGatewayConfig.isSecure = YES;
                webGatewayConfig.webGatewayUrlPath = @"csa/resources/tenants/default";
                
                
                clientConfiguration = [[AOClientConfiguration alloc]init];
                clientConfiguration.configuration = config;
                clientConfiguration.webGatewayConfiguration = webGatewayConfig;
             
                 videoWork.context = @"Context";
                 videoWork.locale = @"en_us";
                 videoWork.routingStrategy = @"MOST_IDLE";
                 videoWork.services = [workConfiguration serviceMapBuilder];
                 videoWork.resources = [workConfiguration resourceMapBuilder];
             
                 videoCustomer = [[AOOceanaCustomerWebVoiceVideo alloc]initWithClientConfiguration:clientConfiguration];
                 videoWork = videoCustomer.createWork;
                 videoWork.context = @"Customer"; //Here will be context
                 audio = videoWork.createAudioInteraction;
             [audio setPlatformType:AOPlatFormType_ELITE];
             audio.authorizationToken = token;
             audio.destinationAddress = @"450151";
             [audio start];
             
             sleep(10);
             
             [audio readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
                 NSLog(@"#Test Audio Details : %@", audioDetails);
                 if (audioDetails && [audioDetails isKindOfClass:[AOAudioDetails class]]) {
                     [expectation fulfill];
                 } else {
                     XCTAssert(audioDetails, @"Not valid Audio Details");
                 }
             }];
         }
     }];
     [task resume];
         
     [self waitForExpectationsWithTimeout:120.0 handler:nil];
}


@end
