//
//  DropDownMenu.m
//  OceanaReferenceClient
//
//  Created by Mohan on 20/02/20.
//  Copyright © 2020 Avaya. All rights reserved.
//

#import "DropDownMenu.h"

@implementation DropDownMenu 



// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
    self.mainTableView = [[UITableView alloc] initWithFrame:rect];
    self.mainTableView.delegate = self;
    [self.mainTableView registerClass:[UITableViewCell self] forCellReuseIdentifier:@"option_cell"];
    self.mainTableView.dataSource = self;
    
    self.mainTableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
    [self addSubview:self.mainTableView];
    
}


#pragma maek- TableView Delegates

- (NSInteger) numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger) tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [self.delegate arrayOfListItems].count;
}

- (UITableViewCell *) tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"option_cell"];
    if (cell != nil) {
        cell.textLabel.text = [[self.delegate arrayOfListItems] objectAtIndex:indexPath.row];
    }
    return cell;
}

-(void) tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    
    [tableView deselectRowAtIndexPath:indexPath animated:NO];
    if ( self.delegate != nil &&[self.delegate respondsToSelector:@selector(menuOptionPressedAtIndex:)]) {
        [self.delegate menuOptionPressedAtIndex: indexPath.row];
    }
}

@end
