//
//  RCCallStatsTableViewController.m
//  OceanaReferenceClient
//
//  Created by Mohan on 13/02/20.
//  Copyright © 2020 Avaya. All rights reserved.
//

#import "RCCallStatsTableViewController.h"
#import "RCCallStatTableViewCell.h"
#import "AFSessionQualityUtil.h"
#import "Constants.h"


@interface RCCallStatsTableViewController () <UITableViewDelegate, UITableViewDataSource>
{
    NSString *csCallType;
}
@property (strong, nonatomic) IBOutlet UITableView *tableView;
@property (strong, nonatomic) NSArray* arrayOfStats;
@property (strong, nonatomic) NSArray* arrayOfVideoStats;
@property (weak, nonatomic) NSTimer *refreshTimer;


@end

@implementation RCCallStatsTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self updateTheCallStatestics];
    csCallType = @"";
    [self.oceanaClient readCallTypeWithCompletionHandler:^(NSString *csCallTypeString) {
        csCallType = csCallTypeString;
    }];
}

-(void) viewWillAppear:(BOOL)animated {
 
    [super viewWillAppear:animated];
    if (!self.refreshTimer) {
        self.refreshTimer = [NSTimer scheduledTimerWithTimeInterval:5 target:self selector:@selector(updateTheCallStatestics) userInfo:nil repeats:YES];
    }
}

-(void) viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    if (self.refreshTimer) {
        [self.refreshTimer invalidate];
        self.refreshTimer = nil;
    }
}

- (void) updateTheCallStatestics {
    
    __weak RCCallStatsTableViewController *weakSelf = self;
    if (self.oceanaClient != nil) {
        [self.oceanaClient readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
            [weakSelf initStatsWithAudioDetails: audioDetails];
        }];
        [self.oceanaClient readCallTypeWithCompletionHandler:^(NSString *csCallTypeString) {
            csCallType = csCallTypeString;
        }];
    } else if (self.oceanaVideoClient != nil) {
        [self.oceanaVideoClient readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
            [weakSelf initStatsWithAudioDetails: audioDetails];
        }];
        [self.oceanaVideoClient readCallTypeWithCompletionHandler:^(NSString *csCallTypeString) {
            csCallType = csCallTypeString;
        }];
    }
}


- (IBAction)closeCallStacView:(UIButton *)sender {
    [self dismissViewControllerAnimated:YES completion:nil];
}

-(void) initStatsWithAudioDetails : (AOAudioDetails* ) currentAudioDetails{
    
    int cpu_usage = roundf([AFSessionQualityUtil cpu_usage]/[AFSessionQualityUtil countCores]);
    self.arrayOfStats = @[
                          @{kNSStringConstCodec:currentAudioDetails.codec},
                          @{kNSStringConstEncryption: [self encryptioTypeToString:currentAudioDetails.mediaEncryptionType]},
                          @{kNSStringConstPacketization: [NSString stringWithFormat:@"%lu", (unsigned long)currentAudioDetails.packetizationIntervalMilliseconds]},
                          @{kNSStringConstRoundTripDelay: [NSString stringWithFormat:@"%lu", (unsigned long)currentAudioDetails.roundTripTimeMilliseconds]},
                          @{kNSStringConstPacketSentReceived:[NSString stringWithFormat:@"%lu / %lu", (unsigned long)currentAudioDetails.packetsTransmitted, (unsigned long)currentAudioDetails.packetsReceived]},
                          @{kNSStringConstBytesSentReceived:[NSString stringWithFormat:@"%lu / %lu", (unsigned long)currentAudioDetails.bytesTransmitted, (unsigned long)currentAudioDetails.bytesReceived]},
                          @{kNSStringConstLocalLossRemote: [NSString stringWithFormat:@"%lu / %lu", (unsigned long)currentAudioDetails.fractionLostTransmitted, (unsigned long)currentAudioDetails.fractionLostReceived]},
                          @{kNSStringConstJitterLocalRemote: [NSString stringWithFormat:@"%lu / %lu", (unsigned long)currentAudioDetails.averageJitterTransmittedMilliseconds, (unsigned long)currentAudioDetails.averageJitterReceivedMilliseconds]},
                          @{kNSStringConstBufferCurrentPref: [NSString stringWithFormat:@"%lu / %lu", (unsigned long)currentAudioDetails.currentBufferSizeMilliseconds, (unsigned long)currentAudioDetails.preferredBufferSizeMilliseconds]},
                          @{ kNSStringConstPacketLoss: [NSString stringWithFormat:@"%lu", (unsigned long)currentAudioDetails.currentPacketLossRate]},
                          @{kNSStringConstDiscardRate: [NSString stringWithFormat:@"%lu%%", (unsigned long)currentAudioDetails.currentDiscardRate]},
                          @{kNSStringConstExpandRate:[NSString stringWithFormat:@"%lu%%", (unsigned long)currentAudioDetails.currentExpandRate]},
                          @{kNSStringConstPremptiveRate:[NSString stringWithFormat:@"%lu%%", (unsigned long)currentAudioDetails.currentPreemptiveRate]},
                          @{kNSStringConstAccelerateRate: [NSString stringWithFormat:@"%lu%%", (unsigned long)currentAudioDetails.currentAccelerationRate]},
                          @{kNSStringConstCallType:csCallType},
                          @{ kNSStringConstRTPTransport:currentAudioDetails.mediaTunnelled ? @"TLS" : @"UDP"},
                          @{ kNSStringConstProcessorUsage:[NSString stringWithFormat:@"%d %%", cpu_usage]}
                          ];
    [self.tableView reloadData];    
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    return self.arrayOfStats.count;
}


- (RCCallStatTableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    RCCallStatTableViewCell *cell =(RCCallStatTableViewCell*) [tableView dequeueReusableCellWithIdentifier:@"call_stat_cell" forIndexPath:indexPath];
    if (cell != nil) {
        
        cell.propertyLabel.text = [[[self.arrayOfStats objectAtIndex:indexPath.row] allKeys] firstObject];
        NSString *key = [[[self.arrayOfStats objectAtIndex:indexPath.row] allKeys] firstObject];
        cell.valueLabel.text = [[self.arrayOfStats objectAtIndex:indexPath.row] valueForKey:key];
    }
    return cell;
}
- (IBAction)backButtonPressed:(UIBarButtonItem *)sender {
    [self.tabBarController dismissViewControllerAnimated:YES completion:nil];
    
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return UITableViewAutomaticDimension;
}


- (NSString*)encryptioTypeToString:(AOMediaEncryptionType)formatType {
    NSString *result = nil;
    
    switch(formatType) {
        case AOMediaEncryptionTypeNone:
            result = @"AOMediaEncryptionTypeNone";
            break;
        case AOMediaEncryptionTypeAES128SHA1HMAC80:
            result = @"AOMediaEncryptionTypeAES128SHA1HMAC80";
            break;
        case AOMediaEncryptionTypeAES128SHA1HMAC32:
            result = @"AOMediaEncryptionTypeAES128SHA1HMAC32";
            break;
        case AOMediaEncryptionTypeAES256SHA1HMAC80:
            result = @"AOMediaEncryptionTypeAES256SHA1HMAC80";
            break;
        case AOMediaEncryptionTypeAES256SHA1HMAC32:
            result = @"AOMediaEncryptionTypeAES256SHA1HMAC32";
            break;
        default:
            result = @"AOMediaEncryptionTypeNone";
    }
    
    return result;
}


/*
 // Override to support conditional editing of the table view.
 - (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
 // Return NO if you do not want the specified item to be editable.
 return YES;
 }
 */

/*
 // Override to support editing the table view.
 - (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
 if (editingStyle == UITableViewCellEditingStyleDelete) {
 // Delete the row from the data source
 [tableView deleteRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationFade];
 } else if (editingStyle == UITableViewCellEditingStyleInsert) {
 // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
 }
 }
 */

/*
 // Override to support rearranging the table view.
 - (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
 }
 */

/*
 // Override to support conditional rearranging of the table view.
 - (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
 // Return NO if you do not want the item to be re-orderable.
 return YES;
 }
 */

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
