//
//  InCallView.m
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//

#import <Foundation/Foundation.h>
#import "InCallView.h"
#import "RightSideBarViewController.h"
#import "MenuViewController.h"
#import "Logging.h"
#import "AVFoundation/AVFoundation.h"
#import "AppSettings.h"
#import "VideoCallView.h"
#import "RCCallStatsTableViewController.h"
#import "DropDownMenu.h"
#import "GraphStatsViewController.h"
#import <OceanaCustomerWebVoiceVideo/OceanaCustomerWebVoiceVideo.h>

@interface InCallView()
{
    BOOL isDTMFShowing;
}

@property UIImage* audioOn;
@property UIImage* audioOff;

@property UIImage* showDTMF;
@property UIImage* hideDTMF;
@property (weak, nonatomic) IBOutlet UIButton *menuButton;

@property UIImage* hold;
@property UIImage* unhold;
@property UIImage* speaker_on;
@property UIImage* speaker_off;
@property UIImage* bluetooth;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *dtmfViewConstarint;
@property (weak, nonatomic) IBOutlet UIView *mainCallVIewContainer;

@property (nonatomic, strong)AOAudioDetails *currentAudioDetails;

#pragma mark- Updated UI Outlets

@property (weak, nonatomic) IBOutlet UILabel *callStatelabel;
@property (weak, nonatomic) IBOutlet UILabel *timeLapsedLabel;
@property (weak, nonatomic) IBOutlet UIButton *holdButton;
@property (weak, nonatomic) IBOutlet UIButton *dtmfButton;
@property (weak, nonatomic) IBOutlet AVRoutePickerView *audioRouteButton;

@property (weak, nonatomic) IBOutlet UIProgressView *emosProgressBar;
@property (weak, nonatomic) IBOutlet UILabel *eMOSCOuntLabel;
@property (weak, nonatomic) IBOutlet UIView *emosView;
@property (weak, nonatomic) IBOutlet UIImageView *netwotkQualityImageView;
@property (weak, nonatomic) IBOutlet UILabel *emosLabelwithImage;

@end

@implementation InCallView : UIViewController

NSTimer* callTimer;
NSString* state;
NSString* const MENU_SEGUE = @"returnToMenu";
AAWGTokenRequest* aawgTokenRequest;
NSString* amvToken;



- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.gradientView = [[GradientView alloc] initWithFrame:self.inCallView.bounds];
    self.gradientView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
//    self.gradientView.layer.colors = [NSArray arrayWithObjects:(id)[[UIColor colorWithRed:(218/255.0) green:(41/255.0) blue:(28/255.0) alpha:1] CGColor], (id)[[UIColor colorWithRed:(86/255.0) green:(90/255.0) blue:(92/255.0) alpha:1] CGColor], nil];
    [self.inCallView insertSubview:self.gradientView atIndex:0];
    
    [self checkMicrophonePermissions];
    
    //Images used to change the appearance of the audio mute buttons
    self.audioOn = [UIImage imageNamed:@"audioOn.png"];
    self.audioOff = [UIImage imageNamed:@"audioOff.png"];
    self.showDTMF = [UIImage imageNamed:@"dtmf.png"];
    self.hideDTMF = [UIImage imageNamed:@"hideDtmf.png"];
    self.hold = [UIImage imageNamed:@"Hold.png"];
    self.unhold = [UIImage imageNamed:@"Unhold.png"];
    self.speaker_on = [UIImage imageNamed:@"speaker_on.png"];
    self.speaker_off = [UIImage imageNamed:@"speaker_off.png"];
    self.bluetooth = [UIImage imageNamed:@"ic_bluetooth.png"];
    
    [self.btShowDTMF setImage:self.showDTMF forState:UIControlStateNormal];
    self.vwDTMF.hidden = true;
    self.lbConnected.hidden = true;
    [self createOptionMenuForThisScreen];
    aawgTokenRequest = [[AAWGTokenRequest alloc]init];
    [self getAAWGToken];
    state = @"Idle";
    isDTMFShowing = NO;
        
    UITapGestureRecognizer *singleTap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(hidetheDTMFView)];
    singleTap.numberOfTouchesRequired = 1;
    singleTap.numberOfTapsRequired = 1;
    [self.mainCallVIewContainer addGestureRecognizer:singleTap];
    
    AVRoutePickerView *routePickerView = [[AVRoutePickerView alloc] initWithFrame:CGRectMake(0.0f, 30.0f, 30.0f, 30.0f)];
    routePickerView.activeTintColor = [UIColor redColor];
    
    self.audioRouteButton.activeTintColor = [UIColor whiteColor];
    
}

-(void) viewWillAppear:(BOOL)animated {
    [self orientationChanged:nil];
    [super viewWillAppear:animated];
    [[UIDevice currentDevice] beginGeneratingDeviceOrientationNotifications];
    [[NSNotificationCenter defaultCenter]
       addObserver:self selector:@selector(orientationChanged:)
       name:UIDeviceOrientationDidChangeNotification
       object:[UIDevice currentDevice]];
}

-(void) viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    NSNotificationCenter *center = [NSNotificationCenter defaultCenter];
    [center removeObserver:self name:UIDeviceOrientationDidChangeNotification object:nil];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)getAAWGToken
{
    [aawgTokenRequest getAuthenticationToken:[AppSettings getTokenServiceAddress] displayName:[AppSettings getDisplayName] fromAddress:[AppSettings getUsername] andNotify:self];
}

/**
 *  Shows the DTMF View
 */
- (IBAction)btDTMF_Pressed:(id)sender
{
    if ([self.btShowDTMF isSelected]) {
        [self.btShowDTMF setImage:self.hideDTMF forState:UIControlStateNormal];
        [self showDTMFView];
    } else {
        [self.btShowDTMF setImage:self.showDTMF forState:UIControlStateSelected];
        [self hideDTMFView];
    }
    [self.btShowDTMF setSelected: !self.btShowDTMF.isSelected];
}

- (void) showDTMFView
{
    
    [UIView transitionWithView:self.vwControls
                      duration:0.3
                       options:UIViewAnimationOptionTransitionCrossDissolve
                    animations:^{
        self.vwDTMF.hidden = NO;
        self.vwControls.alpha = 0.0;
        self.btHangup.alpha = 0.0;
    }   completion:^(BOOL finished) {
        [self.mainCallVIewContainer bringSubviewToFront:self.vwDTMF];
    }];
}

- (void) hideDTMFView
{
    [UIView transitionWithView:self.vwControls
                      duration:0.3
                       options:UIViewAnimationOptionTransitionCrossDissolve
                    animations:^{
        self.vwControls.alpha = 1.0;
        self.btHangup.alpha = 1.0;
        self.vwDTMF.hidden = YES;
    }   completion:^(BOOL finished) {
        [self.mainCallVIewContainer bringSubviewToFront:self.vwDTMF];
    }];
}

- (IBAction)btDTMFTone_Pressed:(id)sender
{
    
    UIButton* button = (UIButton*)sender;
    long digit = [button tag];
    switch (digit) {
        case 0:
            [self.oceanaClient sendDTMF:AODTMFToneZero];
            break;
        case 1:
            [self.oceanaClient sendDTMF:AODTMFToneOne];
            break;
        case 2:
            [self.oceanaClient sendDTMF:AODTMFToneTwo];
            break;
        case 3:
            [self.oceanaClient sendDTMF:AODTMFToneThree];
            break;
        case 4:
            [self.oceanaClient sendDTMF:AODTMFToneFour];
            break;
        case 5:
            [self.oceanaClient sendDTMF:AODTMFToneFive];
            break;
        case 6:
            [self.oceanaClient sendDTMF:AODTMFToneSix];
            break;
        case 7:
            [self.oceanaClient sendDTMF:AODTMFToneSeven];
            break;
        case 8:
            [self.oceanaClient sendDTMF:AODTMFToneEight];
            break;
        case 9:
            [self.oceanaClient sendDTMF:AODTMFToneNine];
            break;
        case 10:
            [self.oceanaClient sendDTMF:AODTMFToneStar];
            break;
        case 11:
            [self.oceanaClient sendDTMF:AODTMFTonePound];
            break;
        case 12:
            [self.oceanaClient sendDTMF:AODTMFToneA];
            break;
        case 13:
            [self.oceanaClient sendDTMF:AODTMFToneB];
            break;
        case 14:
            [self.oceanaClient sendDTMF:AODTMFToneC];
            break;
        case 15:
            [self.oceanaClient sendDTMF:AODTMFToneD];
            break;
        default:
            [Logging logWarn:@"Unknown tag received to send DTMF: %d", digit];
            break;
    }
}

- (IBAction)btHangup_Pressed:(id)sender
{
    [self.oceanaClient endInteraction];
}

/**
 * Toggle Hold Button Press Handler
 */

- (IBAction)btHold_Pressed:(id)sender {
    [self.oceanaClient toggleHold];
}


/**
 * Toggle Audio Mute Button Press Handler
 */
//TODO: Remove logger
- (IBAction) btToggleAudioMute_Pressed:(id)sender
{
    [self.oceanaClient toggleMuteAudio];
    [self.oceanaClient readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
    }];
}

/**
 * Toggles the audio mute state and updates btMuteAudio's appearance
 */
- (void) toggleAudioMuteButton
{
    //Change the button appearance
    if ([self.btMuteAudio isSelected]) {
        [self.btMuteAudio setImage:self.audioOff forState:UIControlStateNormal];
    } else {
        [self.btMuteAudio setImage:self.audioOn forState:UIControlStateSelected];
    }
    [self.btMuteAudio setSelected: !self.btMuteAudio.isSelected];
}

- (void) setCallTimer
{
    if(callTimer != nil){
        [callTimer invalidate];
    }
    callTimer = [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(callTimerFired:) userInfo:nil repeats:YES];
}

- (void) callTimerFired:(NSTimer*)timer
{
    long timeElapsed = [self.oceanaClient getCallTimeElapsed];
    state = [InCallView convertSessionState:[self.oceanaClient getInteractionState]];
    if ([self.oceanaClient isHeld]) {
        state = NSLocalizedString(@"Held",nil);
    }
    timeElapsed = timeElapsed / 1000;
    long mins = timeElapsed / 60;
    long secs = timeElapsed % 60;
    NSString* timeStamp;
    if(secs > 9){
        timeStamp = [NSString stringWithFormat:@"%ld:%ld",mins, secs];
    } else {
        timeStamp = [NSString stringWithFormat:@"%ld:0%ld",mins, secs];
    }
    self.lbState.text = [NSString stringWithFormat:@"%@", state];
    
    self.lbTimer.text = [NSString stringWithFormat:@"%@: (%@)", NSLocalizedString(@"Elapsed Time",nil),timeStamp];
    
    self.callStatelabel.text = [[NSString stringWithFormat:@"%@", state] uppercaseString];
    self.timeLapsedLabel.text = [NSString stringWithFormat:@"(%@)",timeStamp];
    if ([self.oceanaClient getInteractionState] == AOInteractionStateEstablished) {
        //self.emosView.hidden = NO;
//        self.emosLabelwithImage.hidden = NO;
        self.netwotkQualityImageView.hidden = NO;
//    [self updateTheCallStatesticsForAudioCall]; Moved MOS Calculation Logic to SDK
    }
}

//AuthenticationToken Delegate Methods

- (void) getAAWGTokenSuccessful:(NSString *)token
{
    [Logging logDebug:@"%s Token: %@", __PRETTY_FUNCTION__, token];
    amvToken = token;
    OceanaClient* oceanaClient = [[OceanaClient alloc] init];
    self.oceanaClient = oceanaClient;
    [self.oceanaClient setAudioDelegate:self];
    [self.oceanaClient setConnectionlistenerDelegate:self];
    [self.oceanaClient configureAudio];
    [self.oceanaClient setAuthorizationToken:amvToken];
    [self.oceanaClient startInteraction];
    [Logging logDebug:@"%s OceanaClient versionNumber: %@", __PRETTY_FUNCTION__, self.oceanaClient.versionNumber];
}

- (void) getAAWGTokenFailed:(NSError *)error
{
    [Logging logError:@"%s Error: %@", __PRETTY_FUNCTION__, error];
    dispatch_async(dispatch_get_main_queue(), ^{
        UIAlertController *alert = [UIAlertController
                                    alertControllerWithTitle:NSLocalizedString(@"Token Request Error",nil)
                                    message:[error localizedDescription]
                                    preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction *okButton = [UIAlertAction
                                   actionWithTitle:NSLocalizedString(@"OK",nil)
                                   style:UIAlertActionStyleDefault
                                   handler:^(UIAlertAction * _Nonnull action) {
            [self performSegueWithIdentifier:@"returnToMenu" sender:self];
        }];
        [alert addAction:okButton];
        [self presentViewController:alert animated:YES completion:nil];
    });
}

//AOConnectionListener Delegate Methods

- (void)interactionServiceConnecting
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    self.lbConnected.hidden = TRUE;
    self.lbDialling.hidden = FALSE;
}

- (void)interactionServiceConnected
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    self.lbConnected.hidden = FALSE;
    self.lbDialling.hidden = TRUE;
}

- (void)interactionServiceDisconnectedWithError:(NSError *)error
{
    [Logging logInfo:@"%s Error: %@", __PRETTY_FUNCTION__, error];
}

//AOAudioInteraction Delegate Methods

- (void)interactionInitiating
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    state = [InCallView convertSessionState:[self.oceanaClient getInteractionState]];
}

- (void)interactionActive
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    state = [InCallView convertSessionState:[self.oceanaClient getInteractionState]];
    self.lbDialling.hidden = true;
    self.lbConnected.hidden = false;
}

- (void)interactionFailed:(NSError *)error
{
    [Logging logInfo:@"%s Error: %@", __PRETTY_FUNCTION__, error];
    if(callTimer != nil){
        [callTimer invalidate];
        self.lbState.text = nil;
        state = nil;
        self.callStatelabel.text = @"";
    }
    state = [InCallView convertSessionState:[self.oceanaClient getInteractionState]];
    [self showError:error forMethod:NSLocalizedString(@"Start Interaction",nil)];
}

- (void)interactionRemoteAlerting
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    state = [InCallView convertSessionState:[self.oceanaClient getInteractionState]];
    [self setCallTimer];
}

- (void)interactionEnded
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    if(callTimer != nil){
        [callTimer invalidate];
        self.lbState.text = nil;
        self.callStatelabel.text = @"";
        state = nil;
    }
    state = [InCallView convertSessionState:[self.oceanaClient getInteractionState]];
    [self.oceanaClient discard];
}

- (void)interactionAudioMuteStatusChanged:(BOOL)isMuted
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    [self toggleAudioMuteButton];
}

- (void)holdComplete
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    [self.btHold setImage:self.unhold forState:UIControlStateNormal];
    [self.holdButton setImage:[UIImage imageNamed:@"ic_unhold"] forState:UIControlStateNormal];
}

- (void)unholdComplete
{
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    [self.btHold setImage:self.hold forState:UIControlStateNormal];
    [self.holdButton setImage:[UIImage imageNamed:@"ic_hold"] forState:UIControlStateNormal];
}

- (void)discardComplete {
    [Logging logInfo:@"%s", __PRETTY_FUNCTION__];
    [self performSegueWithIdentifier:@"returnToMenu" sender:self];
}

- (void)onInteractionQualityChanged:(AOCallQuality) quality {
    [self renderCallQuality:quality];
}

/**
 * Converts a session state to a NSString
 */
+ (NSString* ) convertSessionState: (AOInteractionState) state
{
    switch (state) {
        case AOInteractionStateEnded:
            return NSLocalizedString(@"Ended",nil);
        case AOInteractionStateEstablished:
            return NSLocalizedString(@"Established",nil);
        case AOInteractionStateFailed:
            return NSLocalizedString(@"Failed",nil);
        case AOInteractionStateInitiating:
            return NSLocalizedString(@"Initiating",nil);
        case AOInteractionStateRemoteAlerting:
            return NSLocalizedString(@"Alerting",nil);
        case AOInteractionStateIdle:
            return NSLocalizedString(@"Idle",nil);
        default:
            return [NSString stringWithFormat: @"Tried to convert non convertable state %ld", (long)state];
    }
}

/**
 * Utility method to pop an alert with a given error and title
 */
- (void) showError:(NSError*)error forMethod:(NSString*)methodName
{
    NSString* errorMessage =[error localizedFailureReason];
    if(errorMessage == nil || [errorMessage length] < 1){
        errorMessage = [error localizedDescription];
        
        if(errorMessage == nil || [errorMessage length] < 1){
            errorMessage = [error description];
        }
    }
    
    [self showError:methodName withMessage:errorMessage];
}

- (void) showError:(NSString*)method withMessage:(NSString*) message
{
    UIAlertController *alert = [UIAlertController
                                alertControllerWithTitle:[NSString stringWithFormat:@"%@: %@",NSLocalizedString(@"Error",nil) ,method]
                                message:message
                                preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *okButton = [UIAlertAction
                               actionWithTitle:NSLocalizedString(@"OK",nil)
                               style:UIAlertActionStyleDefault
                               handler:^(UIAlertAction * _Nonnull action) {
        [self.oceanaClient discard];
    }];
    [alert addAction:okButton];
    [self presentViewController:alert animated:YES completion:nil];
}

- (void)checkMicrophonePermissions
{
    AVAudioSessionRecordPermission permissionStatus = [[AVAudioSession sharedInstance] recordPermission];
    switch (permissionStatus) {
        case AVAudioSessionRecordPermissionUndetermined: {
            [Logging logInfo:@"%s Microphone Permission Undetermined", __PRETTY_FUNCTION__];
            [[AVAudioSession sharedInstance] requestRecordPermission:^(BOOL granted) {
                if (granted) {
                    [Logging logInfo:@"%s Microphone Permission Granted", __PRETTY_FUNCTION__];
                }
                else {
                    [self showError:NSLocalizedString(@"Permissions Denied",nil) withMessage:NSLocalizedString(@"Microphone Permissions Required",nil)];
                }
            }];
            break;
        }
        case AVAudioSessionRecordPermissionDenied:
            [self showError:NSLocalizedString(@"Permissions Denied",nil) withMessage:NSLocalizedString(@"Microphone Permissions Required",nil)];
            break;
        case AVAudioSessionRecordPermissionGranted:
            [Logging logInfo:@"%s Microphone Permission Granted", __PRETTY_FUNCTION__];
            break;
        default:
            break;
    }
}

#pragma mark- Option Menu

-(void) createOptionMenuForThisScreen {
    
    menuArray = @[ NSLocalizedString(@"Call Statistics", nil), NSLocalizedString(@"Call Statistics Graph", nil)];
    isOptionVisible = NO;
    
}

- (IBAction)optionMenuPressed:(UIButton *)sender {
    
    UIAlertController *options = [UIAlertController alertControllerWithTitle:@"" message: NSLocalizedString(@"Select", nil) preferredStyle:UIAlertControllerStyleActionSheet];
    UIAlertAction *action = [UIAlertAction actionWithTitle: menuArray.firstObject style: UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self showCallStatScreen];
    }];
    UIAlertAction *action1 = [UIAlertAction actionWithTitle: [NSString stringWithFormat:@"%@", [menuArray objectAtIndex:1]] style: UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self showCallStatScreenWithGraph];
    }];

    UIAlertAction *Cancelaction = [UIAlertAction actionWithTitle:NSLocalizedString(@"Cancel", nil) style: UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    [options addAction:action];
    [options addAction:action1];
    [options addAction:Cancelaction];
    if (options.popoverPresentationController != nil) {
           options.popoverPresentationController.sourceView = self.view;
           options.popoverPresentationController.sourceRect = CGRectMake(self.view.center.x,self.view.frame.size.height, 0, 0);
           options.popoverPresentationController.permittedArrowDirections = 0;
       }
    [self presentViewController:options animated:YES completion:nil];

}

-(void) showCallStatScreen {
    
    UITabBarController *tbvc = (UITabBarController *)[self.storyboard instantiateViewControllerWithIdentifier:@"call_stats_tabbar"];
    UINavigationController * nv1 = (UINavigationController*)[[tbvc viewControllers] objectAtIndex:0];
    UITabBarItem* videoItem = [tbvc.tabBar.items objectAtIndex:1];
    videoItem.enabled = NO;
    RCCallStatsTableViewController * vc1 = (RCCallStatsTableViewController*)[[nv1 viewControllers] objectAtIndex:0];
    vc1.oceanaClient = self.oceanaClient;
    [self presentViewController:tbvc animated:YES completion: nil];
}

-(void) showCallStatScreenWithGraph {
    
    dispatch_async(dispatch_get_main_queue(), ^{
        UINavigationController *graphNav = (UINavigationController *)[self.storyboard instantiateViewControllerWithIdentifier:@"call_stats_with_graph"];
        GraphStatsViewController * vc1 = (GraphStatsViewController*)[[graphNav viewControllers] objectAtIndex:0];
        vc1.oceanaClient = self.oceanaClient;
        [self presentViewController:graphNav animated:YES completion: nil];
    });
}


- (void)audioRouteChangeListenerCallback:(NSNotification*)notification
{
//    NSDictionary *interuptionDict = notification.userInfo;
//    NSInteger routeChangeReason = [[interuptionDict valueForKey:AVAudioSessionRouteChangeReasonKey] integerValue];
//    if (routeChangeReason != AVAudioSessionRouteChangeReasonOverride) {
//        [self.oceanaClient updateTheOwnerCurrentAudioPath];
//    }
}

-(void) checkAvailableAudioAndChangeThePath {
//    if ([self.oceanaClient isBlootuthIsConnected]) {
//        [self.oceanaClient setAudioPathAs:AudioPathBluetooth];
//    }
//    if ([self.oceanaClient isHeadsetPluggedIn]) {
//        [self.oceanaClient setAudioPathAs:AudioPathNormal];
//    }
}

-(void) hideShowControlsWithAnimation {
 
    if (isDTMFShowing) {
        
        [UIView transitionWithView:self.vwControls
                          duration:0.5
                           options:UIViewAnimationOptionTransitionCrossDissolve
                        animations:^{
            [self.view bringSubviewToFront:self.vwControls];
            self.vwControls.alpha = 0.0;
        }
                        completion:nil];
    } else {
        
        [UIView transitionWithView:self.vwControls
                          duration:0.5
                           options:UIViewAnimationOptionTransitionCrossDissolve
                        animations:^{
            self.vwControls.alpha = 1.0;
            
        }
                        completion:^(BOOL finished){
        }];
    }
}

- (void) orientationChanged:(NSNotification *)note
{
     UIDevice * device = note.object;
        if (!device) {
            device = [UIDevice currentDevice];
        }            
        switch(device.orientation)
        {
            case UIDeviceOrientationPortrait:
            case UIDeviceOrientationPortraitUpsideDown:
                
                self.dtmfViewConstarint.constant = 140;
                break;
                
            case UIDeviceOrientationLandscapeLeft:
            case UIDeviceOrientationLandscapeRight:
                self.dtmfViewConstarint.constant = 30;
                break;
                
            default:
                break;
        };
    [self.vwControls bringSubviewToFront:self.vwDTMF];
}

-(void) hidetheDTMFView {
    
    if (isDTMFShowing){
//        [self btDTMF_Pressed:nil];
        [self dtmfButtonPressed: self.dtmfButton];
    }
}

#pragma mark- Actions For Updated UI (New User Interface File)

- (IBAction)muteButtonPressed:(UIButton *)sender {
    [self.oceanaClient toggleMuteAudio];
    [self.oceanaClient readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
    }];
    
    if ([sender isSelected]) {
        [sender setImage:[UIImage imageNamed:@"ic_mute_button"] forState:UIControlStateNormal];
    } else {
        [sender setImage:[UIImage imageNamed:@"ic_unmute_button"] forState:UIControlStateNormal];
    }
    [sender setSelected: !sender.isSelected];
}
- (IBAction)dtmfButtonPressed:(UIButton *)sender {
    
    if (isDTMFShowing) {
        [self hideDTMFView];
        [sender setImage:[UIImage imageNamed:@"ic_dtmf_off"] forState:UIControlStateNormal];
    } else {
        [self showDTMFView];
        [sender setImage:[UIImage imageNamed:@"ic_dtmf_on"] forState:UIControlStateNormal];
    }
    isDTMFShowing =! isDTMFShowing;
}
- (IBAction)holdButtonPressed:(UIButton *)sender {
    
    [self.oceanaClient toggleHold];
//    if ([sender isSelected]) {
//        [sender setImage:[UIImage imageNamed:@"ic_hold"] forState:UIControlStateNormal];
//    } else {
//        [sender setImage:[UIImage imageNamed:@"ic_unhold"] forState:UIControlStateNormal];
//    }
//    [sender setSelected: !sender.isSelected];
}
- (IBAction)hangupButtonPressed:(UIButton *)sender {
    [self.oceanaClient endInteraction];
}
//Moved MOS Calculation Logic to SDK
/*
- (void) updateTheCallStatesticsForAudioCall {
    if (self.oceanaClient != nil) {
          [self.oceanaClient readAudioDetailsWithCompletionHandler:^(AOAudioDetails *audioDetails) {
                                        [self getMOSFromTheAudioCallStats: audioDetails];
          }];
      }
}*/

-(void)renderCallQuality:(AOCallQuality)quality {
    NSString* callQualityRatingResource = @"";
    NSString* callQualityText = @"No_Network";
    if (quality == AOCallQualityExcellent) {
        callQualityRatingResource = @"5";
        callQualityText = @"Excellent";
    } else if (quality == AOCallQualityGood) {
        callQualityRatingResource = @"4";
        callQualityText = @"Good";
    } else if (quality == AOCallQualityFair) {
        callQualityRatingResource = @"3";
        callQualityText = @"Fair";
    } else if (quality == AOCallQualityPoor) {
        callQualityRatingResource = @"2";
        callQualityText = @"Poor";
    } else if (quality == AOCallQualityBad) {
        callQualityRatingResource = @"1";
        callQualityText = @"Bad";
    }
    dispatch_async(dispatch_get_main_queue(), ^{
//        self.eMOSCOuntLabel.text = callQualityText;
        self.netwotkQualityImageView.image = [UIImage imageNamed: [NSString stringWithFormat:@"ic_networkquality_%@",callQualityRatingResource]];
        self.emosLabelwithImage.text = callQualityText;
    });
}

@end
