 //
 //  NetworkListener.h
 //  Oceana™ReferenceClient
 //
 //  Copyright 2016 Avaya Inc
 //  All rights reserved. Usage of this source is bound to the terms described the file
 //  Avaya SDK EULA.txt, included in this SDK.
 //  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
 //
 //

#import "Reachability.h"
#import <UIKit/UIKit.h>

@interface NetworkListener : NSObject

/**
 * Start listening for network events
 */
- (void) startListening;

/**
 * Stop listening for network events
 */
- (void) stopListening;

/**
 * Checks the current network state. Will pop a dialog if network is not connected or if on 3G.
 */
-(void) checkNetworkCoverage:(NSNotification *)notice;

/**
 * Get singleton instance.
 */
+(id)getInstance;
@end
