//
//  RightSideBarViewController.m
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//

#import <Foundation/Foundation.h>
#import "RightSideBarViewController.h"
#import "Logging.h"
#import "MenuViewController.h"
#import "AppDelegate.h"
#import <AvayaClientServicesLite/AvayaClientServicesLite.h>


@interface RightSidebarViewController ()
//@property (weak, nonatomic) IBOutlet UILabel *headerLabel;
//Avaya Oceana™
@end

@implementation RightSidebarViewController {
    NSArray *menuItems;
}

- (id)initWithStyle:(UITableViewStyle)style
{
    self = [super initWithStyle:style];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    menuItems = @[@"Label", @"AudioCall", @"VideoCall"];
    #ifdef DEBUG_1
        menuItems = @[@"Label", @"AudioCall", @"VideoCall", @"Change Audio CODEC"];
    #endif
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(void) viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
//    self.headerLabel.text = @"Avaya Oceana™";
//    self.headerLabel.text = @"Elite Oceana™";
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    // Return the number of sections.
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    // Return the number of rows in the section.
    return menuItems.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSString *CellIdentifier = [menuItems objectAtIndex:indexPath.row];
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier forIndexPath:indexPath];
//    if (indexPath.row == 0 && indexPath.section == 0) {
//        UILabel *headerLabel = (UILabel *) [cell.contentView viewWithTag:101];
////        headerLabel.text = @"Elite Oceana™";
//    }
    
    return cell;
}

#ifdef DEBUG_1
-(void) tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    if (indexPath.row == 3) {
        [self.revealViewController rightRevealToggleAnimated:YES];
        [self showAndSelectTheAudioCodec];
        
    }
}

-(void) showAndSelectTheAudioCodec {
    
    AppDelegate *appdelegate = (AppDelegate*) [[UIApplication sharedApplication] delegate];
    
    UIAlertController *actionSheet = [UIAlertController alertControllerWithTitle:@"Select From" message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
    
    UIAlertAction *g711Action = [UIAlertAction actionWithTitle:@"G.711" style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        
     appdelegate.selectedCodec = CSAudioCodecG711A;
        [self dismissViewControllerAnimated:YES completion:^{
            
        }];
    }];
    
    UIAlertAction *opusAction = [UIAlertAction actionWithTitle:@"OPUS" style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        appdelegate.selectedCodec = CSAudioCodecOpus;
        [self dismissViewControllerAnimated:YES completion:^{
            
        }];
    }];
        
    switch (appdelegate.selectedCodec) {
        case CSAudioCodecG711A:
            [g711Action setValue:@true forKey:@"checked"];
            break;
        case CSAudioCodecOpus:
            [opusAction setValue:@true forKey:@"checked"];
            break;
        default:

            break;
    }
    
    [actionSheet addAction:g711Action];
    [actionSheet addAction:opusAction];
    
    [actionSheet addAction:[UIAlertAction actionWithTitle:NSLocalizedString(@"Cancel",nil) style:UIAlertActionStyleCancel handler:^(UIAlertAction *action) {
        [self dismissViewControllerAnimated:YES completion:^{
            
        }];
    }]];
    if (actionSheet.popoverPresentationController != nil) {
           actionSheet.popoverPresentationController.sourceView = self.view;
           actionSheet.popoverPresentationController.sourceRect = CGRectMake(self.view.center.x,self.view.frame.size.height, 0, 0);
           actionSheet.popoverPresentationController.permittedArrowDirections = 0;
       }
    [self presentViewController:actionSheet animated:YES completion:nil];    
}



#endif
@end
