/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>

@class CSSimRingCallbackDestination;

/**
 * This class represents the parameters of the destination for the callback /
 * simultaneous ring feature.
 * @see CSCallFeatureService::simRingCallback
 * @see CSCallFeatureServiceDelegate::callFeatureService:didChangeSimRingCallbackStatus:
 */
@interface CSSimRingCallbackDestination : NSObject

/**
 * Constructs an empty CSSimRingCallbackDestination object.
 */
- (instancetype)init;

/**
 * Constructs a CSSimRingCallbackDestination object from the specified parameters.
 *
 * @param number The destination number.
 * @param label The destination label. Can be empty.
 * @param simultaneousRingEnabled YES if incoming calls should be received at this destination
 *                                simultaneously with the user's extension, NO otherwise.
 */

- (instancetype)initWithNumber:(NSString*)number
                         label:(NSString*)label
       simultaneousRingEnabled:(BOOL)simultaneousRingEnabled;

/**
 * The destination number.
 */
@property(nonatomic, readonly) NSString *number;

/**
 * The destination label.
 */
@property(nonatomic, readonly) NSString * label;

/**
 * Returns true if incoming calls should be received at this destination
 * simultaneously with the user's extension, false otherwise.
 */
@property(nonatomic, readonly) BOOL simultaneousRingEnabled;

@end
