 //
 //  IssueReporter.m
 //  Oceana™ReferenceClient
 //
 //  Copyright 2016 Avaya Inc
 //  All rights reserved. Usage of this source is bound to the terms described the file
 //  Avaya SDK EULA.txt, included in this SDK.
 //  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
 //
 //

#import <Foundation/Foundation.h>
#import "IssueReporter.h"
#import "Logging.h"
#import "AppSettings.h"

@implementation IssueReporter


+(void) reportIssue: (UIViewController<MFMailComposeViewControllerDelegate> *) controller
{
    
    
    MFMailComposeViewController *picker = [[MFMailComposeViewController alloc] init];
    picker.mailComposeDelegate = controller;
    
    NSString* uuid = [[NSUUID UUID] UUIDString];
    [picker setSubject:[NSString stringWithFormat:@"Issue Report %@", uuid]];
    
    // Add Your company's support address(es) here
    NSArray *toRecipients = [NSArray arrayWithObject:@""];
    
    [picker setToRecipients:toRecipients];
    
    NSString* logName = [AppSettings getLogFileName];
    
    //get the file extension
    NSString* extension = [logName pathExtension];
    
    //Remove the extension and the . from the logname
    NSString* fileName = [logName substringToIndex:[logName length] - [extension length] - 1];
    
    NSMutableArray* logFiles = [Logging getErrorLogs];
    
    for(int i =0; i < logFiles.count; i++) {
        [picker addAttachmentData:logFiles[i] mimeType:@"text/plain" fileName:[NSString stringWithFormat:@"%@%d.%@",fileName, i, extension]];
    }
    
//*******Saving NSLogs to file*********
//    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask, YES);
//    NSString *documentsDirectory = [paths objectAtIndex:0];
//    NSString *myFileName =[NSString stringWithFormat:@"CompleteLog.log"];
//    NSString *logFilePath = [documentsDirectory stringByAppendingPathComponent:myFileName];
//    if([[NSFileManager defaultManager] fileExistsAtPath:logFilePath]) {
//        NSData *fileData = [NSData dataWithContentsOfFile:logFilePath];
//        [picker addAttachmentData:fileData mimeType:@"text/plain" fileName:myFileName];
//        [[NSFileManager defaultManager] removeItemAtPath:logFilePath error:nil];
//        freopen([logFilePath cStringUsingEncoding:NSASCIIStringEncoding],"a+",stderr);
//    }
    
    
    //Get the SDK logs from ASL
    NSData* aslLogs = [Logging readASLLogs];
    if ([MFMailComposeViewController canSendMail] && picker) {
        
        [picker addAttachmentData:aslLogs mimeType:@"text/plain" fileName:@"SDK_ASL.log"];
        
        // Fill out the email body text
        NSString *emailBody = @"Add any relevant information here.";
        [picker setMessageBody:emailBody isHTML:NO];
        [controller presentViewController:picker animated:YES completion:nil];
    } else {
        
        UIAlertController *alert = [UIAlertController
                                    alertControllerWithTitle:@"Error"
                                    message:@"Please configure email to use this service"
                                    preferredStyle:UIAlertControllerStyleAlert];
        UIAlertAction *okButton = [UIAlertAction
                                   actionWithTitle:@"OK"
                                   style:UIAlertActionStyleDefault
                                   handler:^(UIAlertAction * _Nonnull action) {
                                   }];
        [alert addAction:okButton];
        [ controller presentViewController:alert animated:YES completion:nil];
    }
}

@end
