//
//  OceanaVideoClient.h
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//

#import "OceanaCustomerWebVoiceVideo/OceanaCustomerWebVoiceVideo.h"

@interface OceanaVideoClient : NSObject

- (void) setAuthorizationToken:(NSString*)token;

- (void) configureInteraction;

- (void) startInteraction;

- (void) endInteraction;

- (void) discard;

- (void) sendDTMF:(AODTMFTone) tone;

- (void) toggleMuteAudio;

- (void) toggleMuteVideo;

- (void) toggleVideoEnabled;

- (void) toggleHold;

- (long) getCallTimeElapsed;

- (void) setVideoDelegate:(NSObject<AOVideoInteractionDelegate>*)delegate;

- (void) setConnectionDelegate:(NSObject<AOConnectionListenerDelegate>*)delegate;

- (BOOL) isHeld;

- (AOInteractionState) getInteractionState;

- (void)readVideoDetailsWithCompletionHandler:(void (^)(AOVideoDetails *videoDetails))handler;

- (void)readAudioDetailsWithCompletionHandler:(void (^)(AOAudioDetails *audioDetails))handler;

- (void)readCallTypeWithCompletionHandler:(void (^)(NSString *csCallTypeString))handler;

//VideoDevice

- (void) setRemoteView:(UIView*) remote;

- (void) setLocalView:(UIView*) local;

- (void) selectCamera: (AOCameraType) cameraType;

- (void)switchCamera;

-(BOOL) isVideoEnabled;
@end
