//
//  VideoCallView.h
//  Oceana™ReferenceClient
//
//  Copyright 2016 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//

#ifndef Mobile_Client_DialView_h
#define Mobile_Client_DialView_h
#endif

#import <UIKit/UIKit.h>
#import "OceanaVideoClient.h"
#import "AAWGTokenRequest.h"
#import "GradientView.h"
#import "AVKit/AVKit.h"

@protocol AOCallQualityChangeDelegate <NSObject>
- (void)callQualityChangedTo:(AOCallQuality)quality;
@end

@interface VideoCallView : UIViewController<AOVideoInteractionDelegate, AOConnectionListenerDelegate, AAWGTokenRequestDelegate>
{
    NSArray *menuArray;
    BOOL isOptionVisible;
}



@property (strong) OceanaVideoClient* oceanaVideoClient;
@property (strong, nonatomic) IBOutlet UIView *vwDTMF;
@property (strong, nonatomic) IBOutlet UIButton *btShowDTMF;
@property (weak, nonatomic) IBOutlet UIButton *btHold;

@property (strong, nonatomic) IBOutlet UIButton *btMuteAudio;
@property (strong, nonatomic) IBOutlet UILabel *lbState;
@property (strong, nonatomic) IBOutlet UILabel *lbTimer;
@property (strong, nonatomic) IBOutlet UIView *vwControls;
@property (strong, nonatomic) IBOutlet UIButton *btHangup;

@property (weak, nonatomic) IBOutlet AVRoutePickerView *routePickerView;

- (IBAction)btToggleAudioMute_Pressed:(id)sender;
- (IBAction)btDTMF_Pressed:(id)sender;
- (IBAction)btDTMFTone_Pressed:(id)sender;
- (IBAction)btHangup_Pressed:(id)sender;
- (IBAction)btHold_Pressed:(id)sender;

@property (weak, nonatomic) IBOutlet UIView *vwRemote;
@property (weak, nonatomic) IBOutlet UIView *vwLocal;
@property (strong, nonatomic) IBOutlet UIButton *btMuteVideo;
@property (strong, nonatomic) IBOutlet UIButton *btEnableVideo;
@property (strong, nonatomic) IBOutlet UIButton *btSwitchCamera;
@property (weak, nonatomic) IBOutlet UIButton *audioPathButton;

- (IBAction)btToggleVideoMute_Pressed:(id)sender;
- (IBAction)btEnableVideo_Pressed:(id)sender;
- (IBAction)btSwapCamera_Pressed:(id)sender;

@property (strong, nonatomic) IBOutlet UIView* videoView;
@property (nonatomic, strong) GradientView *gradientView;

@end
